use Test::More tests => 12;
use strict;

# use the module
use_ok('Musings::Template');

# create object
my $template = Musings::Template->new();
isa_ok($template, "Musings::Template");

# name
$template->template_name('My Cool Template');
is($template->template_name(), 'My Cool Template', 'set template_name()');

# content
$template->template_content('the art of folding paper');
is($template->template_content(), 'the art of folding paper', 'set template_content()');

# commit
is($template->commit(), '1', 'commit()');

# id
my $id = $template->template_id();
like ($id, qr/^\d+$/, 'get template_id()');

# get record based on an id
$template = Musings::Template->new(id => $id);
is ($template->template_name(), 'My Cool Template', 'get template_name() matches based on id');
is ($template->template_content(), 'the art of folding paper', 'get template_content() matches based on id');

# update
$template->template_name('Paperfolding');
$template->template_content('an art as well a craft');
$template->commit();
$template = Musings::Template->new(id => $id);
is ($template->template_name(), 'Paperfolding', 'commit() update');
is ($template->template_content(), 'an art as well a craft', 'commit() update');

# get all
my @templates = Musings::Template->get_templates();
my $template_count = scalar(@templates);
like ($template_count, qr/^\d+$/, "get_templates() $template_count found");

# delete 
is ($template->delete(), '1', 'delete() a template');
