package Musings::DB;

use DBI;
use Musings::Config;
use Carp qw(croak);

my $dbh;

=head1 NAME

Musings::DB

=head1 SYNOPSIS

  use Musings::DB;
  my $dbh = Musings::DB->dbh();
  my $key = Musings::DB->nextID();

=head1 DESCRIPTION

This package connects to a musings database and returns the handle.

=head1 METHODS

=head2 dbh()

Returns database handle to a musings.

=head2 nextID()

Returns an new key

=head1 AUTHORS

Eric Lease Morgan <eric_morgan@infomotions.com>

=cut

sub dbh {

	if ($dbh) { return $dbh }
	$dbh = DBI->connect($Musings::Config::DATA_SOURCE, $Musings::Config::USERNAME, $Musings::Config::PASSWORD) || croak("Can't connect to database.");
	return $dbh;
	
}

sub nextID {

	my $self = shift;
	my $dbh = dbh();
	$dbh->do('UPDATE sequence SET id = id + 1');
	my ($id) = $dbh->selectrow_array('SELECT id FROM sequence');
	if ($id) { return $id }
	else { return }
	
}

1;
