#!/usr/bin/perl

# authors.cgi - a Web interface for managing Musings author names

# Eric Lease Morgan <eric_morgan@infomotions.com>

# 2004-10-31 - first cust


# require the necessary modules
use lib '../lib';
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use Musings::Author;
use strict;
require 'subroutines.pl';

# initialize two global variables
my $cgi = CGI->new;
my $html;

# branch according to the input
if (! $cgi->param('cmd')) { &home }
elsif ($cgi->param('cmd') eq 'create')  { &create }
elsif ($cgi->param('cmd') eq 'find') { &find }
elsif ($cgi->param('cmd') eq 'edit')    { &edit }
elsif ($cgi->param('cmd') eq 'delete')  { &delete }
else { $html = $cgi->p("Unknown command. Call Eric") }

# quit
&gracefulExit;


sub home {

	# build a simple home page
	$html  = $cgi->h1('Manage authors');
	$html .= $cgi->p('Use this script to create, edit, and delete Musings author names.');

}


sub create {

	# initialize the output
	$html = $cgi->h1('Create');
	
	# branch according to the input
	if (! $cgi->param('button')) {
		
		# build the form
		$html .= $cgi->p('Use this form to create an author.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'create');
		$html .= table({-border => 0}, Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item', 'Value']),
							td(['First name', $cgi->textfield(-name => 'first_name')]),
							td(['Middle name', $cgi->textfield(-name => 'middle_name')]),
							td(['Last name', $cgi->textfield(-name => 'last_name')]),
							td(['Email', $cgi->textfield(-name => 'email')]),
							td(['URL', $cgi->textfield(-name => 'url')]),
							td([''    , $cgi->submit(-name => 'button', -value => 'Create')])
						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    
    else {
    
    	# create an object, fill it, and save
    	my $author = Musings::Author->new;
    	$author->first_name($cgi->param('first_name'));
    	$author->middle_name($cgi->param('middle_name'));
    	$author->last_name($cgi->param('last_name'));
    	$author->email($cgi->param('email'));
    	$author->url($cgi->param('url'));
		$author->commit;
				
		# echo the results
		$html .= $cgi->p('Author created:');
		$html .= $cgi->ul(li('ID -', $author->author_id),
		                  li('First name - ', $author->first_name),
		                  li('Middle name - ', $author->middle_name),
		                  li('Last name - ', $author->last_name),
		                  li('Email - ', $author->email),
		                  li('URL - ', $author->url)
		                 );
    
    }
    
}


sub find {

	# initialize the output
	$html  = $cgi->h1('All authors');
	$html .= $cgi->p('This is a list of all the authors:');
	
	# get all the authors, build a list, and display it
	my @authors = Musings::Author->get_authors();
	my $items;
	foreach (@authors) { $items .= $cgi->li($_->first_name, $_->middle_name, $_->last_name, ) }
	$html .= $cgi->ul($items);
	
}


sub edit {

	# initialize the output and a button
	$html = $cgi->h1('Edit authors');
	my $submit .= $cgi->submit(-name => 'button', -value => 'Edit');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# create a hash of authors; needs to be sorted
		my @authors = Musings::Author->get_authors();
		my %authors;
		foreach (@authors) { $authors{$_->author_id} = $_->last_name }
	
		# display a form
		$html .= $cgi->p('Select a author to edit');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->popup_menu(-name => 'id', -values => \%authors);
		$html .= $submit;			 
		$html .= $cgi->endform;

	}
	
	elsif (! $cgi->param('first_name') || ! $cgi->param('last_name')) {
	
    	# create an object based on the input, and create form parts
    	my $author = Musings::Author->new(id => $cgi->param('id'));
    	
		# display an edit form
		$html .= $cgi->p('Use this form to edit a author.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->hidden(-name => 'id', -value => $author->author_id);
		$html .= table({-border => 0},
					Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item', 'Value']),
							td(['ID'  , $author->author_id]),
							td(['First name', $cgi->textfield(-name => 'first_name', -value => $author->first_name)]),
							td(['Middle name', $cgi->textfield(-name => 'middle_name', -value => $author->middle_name)]),
							td(['Last name', $cgi->textfield(-name => 'last_name', -value => $author->last_name)]),
							td(['Email', $cgi->textfield(-name => 'email', -value => $author->email)]),
							td(['URL', $cgi->textfield(-name => 'url', -value => $author->url)]),
							td([''    , $submit])
						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    
	else {

		# create and object, fill it, and save
		my $author = Musings::Author->new(id => $cgi->param('id'));
		$author->first_name($cgi->param('first_name'));
		$author->middle_name($cgi->param('middle_name'));
		$author->last_name($cgi->param('last_name'));
		$author->email($cgi->param('email'));
		$author->url($cgi->param('url'));
		$author->commit;
		
		# echo the results
		$html .= $cgi->p('Author updated:');
		$html .= $cgi->ul(li('ID -', $author->author_id),
		                  li('First name - ', $author->first_name),
		                  li('Middle name - ', $author->middle_name),
		                  li('Last name - ', $author->last_name),
		                  li('Email - ', $author->email),
		                  li('URL - ', $author->url)
		                 );
    
    }

}


sub delete {

	# initialize the output
	$html = $cgi->h1('Delete authors');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# build of hash of all authors; needs to be sorted
		my @authors = Musings::Author->get_authors();
		my %authors;
		foreach (@authors) { $authors{$_->author_id} = $_->last_name }

		# display a pop-up list of authors
		$html .= $cgi->p('Select a author to delete:');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->popup_menu(-name => 'id', -values => \%authors);
		$html .= $cgi->submit(-name => 'button', -value => 'delete', -label => 'Delete');		 
		$html .= $cgi->endform;

	}
	
	elsif ($cgi->param('button') eq 'Delete') {
    
    	# create an object based on input
    	my $author = Musings::Author->new(id => $cgi->param('id'));
    	
		# display a confirmation
		$html .= $cgi->p('Are you sure you want to delete the author named <b>' . $author->last_name . '</b>?');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->hidden(-name => 'id', -value => $author->author_id);
		$html .= $cgi->submit(-name => 'button', -value => 'yes', -label => 'Yes');
		$html .= ' ';
		$html .= $cgi->submit(-name => 'button', -value => 'no', -label => 'No');		 
		$html .= $cgi->endform;
    
    }
    
    elsif ($cgi->param('button') eq 'Yes') {
    
    	# delete the author; do the work and echo the result
    	my $author = Musings::Author->new(id => $cgi->param('id'));
    	$author->delete;
    	$html .= $cgi->p('The author ' . $author->last_name . ' has been deleted.');
    
    }
    
    elsif ($cgi->param('button') eq 'No') {
    
    	# abort
    	my $author = Musings::Author->new(id => $cgi->param('id'));
    	$html .= $cgi->p('The author ' . $author->last_name . ' has <b>not</b> been deleted.');

    }
    
}


sub gracefulExit {

	# output the 'magic line', a standard header, the content, and a standard footer, then done
	print $cgi->header;
	print &header;
	print $html;
	print &footer;
	exit;

}


sub header {

	# get the value of this script
	my $script = $cgi->script_name;
	
	# return a standard html page; notice the stylesheet
	return <<EOH;
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Manage authors</title>
		<link rel='stylesheet' href='style.css' type='text/css' />
	</head>
	<body>
		<div id="navcontainer">
			<ul id="navlist">
				<li><a href="home.cgi">Home</a></li>
				<li><a href="authors.cgi" id="current">Authors</a></li>
				<li><a href="subjects.cgi">Subjects</a></li>
				<li><a href="templates.cgi">Templates</a></li>
				<li><a href="stylesheets.cgi">Stylesheets</a></li>
				<li><a href="articles.cgi">Articles</a></li>
			</ul>
		</div>
	
		<div class='menu'>
			<p><b><a href="$script">Manage authors</a></b></p>
			<a href="$script?cmd=create">Create</a><br />
			<a href="$script?cmd=find">Find all</a><br />
			<a href="$script?cmd=edit">Edit</a><br />
			<a href="$script?cmd=delete">Delete</a><br />
			<br />
		</div>
		
		<div class='content'>
EOH

}
