<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'>

	<xsl:output 
	  method='html'
	  omit-xml-declaration='yes'
	  indent='yes'
	  doctype-public='-//W3C//DTD XHTML 1.0 Transitional//EN' 
	  doctype-system='http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd' />
  	
	<xsl:template match='TEI.2'>
		<html>
		
			<head>
	
				<!-- title tag -->
				<title> 
					<xsl:value-of select='normalize-space(teiHeader/fileDesc/titleStmt/title)' /> / <xsl:value-of select='normalize-space(teiHeader/fileDesc/titleStmt/author)' />
				</title> 
	
				<!-- id -->
				<meta>
					<xsl:attribute name='name'>id</xsl:attribute>
					<xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/idno)' /></xsl:attribute>
				</meta>
	
				<!-- author -->
				<meta>
					<xsl:attribute name='name'>author</xsl:attribute>
					<xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/titleStmt/author)' /></xsl:attribute>
				</meta>
	
				<!-- title tag, again -->
				<meta>
					<xsl:attribute name='name'>brief</xsl:attribute>
					<xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/titleStmt/title)' /></xsl:attribute>
				</meta>
	
				<!-- date -->
				<meta>
					<xsl:attribute name='name'>year</xsl:attribute>
					<xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/profileDesc/creation/date)' /></xsl:attribute>
				</meta>
	
				<!-- publisher -->
				<meta>
					<xsl:attribute name='name'>publisher</xsl:attribute>
					<xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/publisher)' /></xsl:attribute>
				</meta>
	
				<!-- publisher -->
				<meta>
					<xsl:attribute name='name'>extent</xsl:attribute>
					<xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/extent)' /></xsl:attribute>
				</meta>
	
				<!-- source -->
				<meta>
					<xsl:attribute name='name'>source</xsl:attribute>
					<xsl:attribute name='content'>
						<xsl:for-each select="/TEI.2/teiHeader/fileDesc/sourceDesc/p"><xsl:value-of select='normalize-space(.)'/> </xsl:for-each>
					</xsl:attribute>
				</meta>
	
				<!-- notes -->
				<meta>
					<xsl:attribute name='name'>notes</xsl:attribute>
					<xsl:attribute name='content'>
						<xsl:for-each select="/TEI.2/teiHeader/fileDesc/notesStmt/note"><xsl:value-of select='normalize-space(.)'/> </xsl:for-each>
					</xsl:attribute>
				</meta>
	
				<!-- rights -->
				<meta>
					<xsl:attribute name='name'>rights</xsl:attribute>
					<xsl:attribute name='content'><xsl:value-of select='normalize-space(teiHeader/fileDesc/publicationStmt/availability/p)' /></xsl:attribute>
				</meta>
				
				<style type='text/css'>
				
					h1, h2, h3, h4, h5, h6 { font-family : sans-serif };

				</style>
				
			</head>
			
			<body style='margin:5%;'>
				
				<!-- "title" page -->
				<h1 style='text-align:center'><xsl:value-of select='teiHeader/fileDesc/titleStmt/title' /></h1>
				<p style='text-align:center'>Originally written/published in <xsl:value-of select='teiHeader/profileDesc/creation/date' /> by <xsl:value-of select='teiHeader/fileDesc/titleStmt/author' /></p>

				<!-- cool table of contents -->
				<xsl:if test='/TEI.2/text/body/div1'>
					<h2>Table of contents</h2>
					<p>
					<xsl:for-each select="/TEI.2/text/body/div1">
						<a><xsl:attribute name="href">#<xsl:value-of select='./@n' /></xsl:attribute><xsl:value-of select='./@type' /><xsl:value-of select='./head' /></a><br />
					</xsl:for-each>
					</p>
				</xsl:if>
				
				<!-- do the heavy lifting -->
				<xsl:apply-templates/>
				
				<!-- finish up -->
				<hr />
			
				<h2>Colophon</h2>
				<p>This file was originally marked up using the Text Encoding Initiative XML markup language for use in the Infomotions Alex Catalog of Electronic Texts (<a><xsl:attribute name='href'>http://infomotions.com/alex</xsl:attribute>http://infomotions.com/alex/</a>) by <xsl:value-of select='teiHeader/fileDesc/titleStmt/respStmt/name'/> on <xsl:value-of select='teiHeader/fileDesc/publicationStmt/date'/> for the purpose of freely sharing, distributing, and making available works of great literature. This file is placed in the public domain. It's Infomotions unique identifier is <xsl:value-of select='teiHeader/fileDesc/publicationStmt/idno'/>. <xsl:value-of select='teiHeader/fileDesc/sourceDesc/p'/>.</p>
				<p style='text-align:center'><img><xsl:attribute name='src'>http://infomotions.com/logo.gif</xsl:attribute><xsl:attribute name='alt'>Infomotions, Inc.</xsl:attribute></img></p>
				<p style='text-align:center'>"Give back to the 'Net."</p>
			
			</body>
			
		</html>
		
	</xsl:template>
	
	<!-- division #1 (div1) -->
	<xsl:template match="div1">
		<h2><a><xsl:attribute name="name"><xsl:value-of select='./@n' /></xsl:attribute><xsl:attribute name="id">n<xsl:value-of select='./@n' /></xsl:attribute><xsl:value-of select='./head' /></a></h2>
		<xsl:apply-templates />
	</xsl:template>

	<!-- division #2 (div2) -->
	<xsl:template match="div2">
		<h3><xsl:value-of select='./@type' /><xsl:text> </xsl:text><xsl:value-of select='./@n' /><xsl:text>. </xsl:text><xsl:value-of select='./head' /></h3>
		<xsl:apply-templates />
	</xsl:template>

	<!-- division #3 (div3) -->
	<xsl:template match="div3">
		<h4><xsl:value-of select='./@type' /><xsl:text> </xsl:text><xsl:value-of select='./@n' /><xsl:text>. </xsl:text><xsl:value-of select='./head' /></h4>
		<xsl:apply-templates />
	</xsl:template>

	<!-- division #4 (div4) -->
	<xsl:template match="div4">
		<h5><xsl:value-of select='./@type' /><xsl:text> </xsl:text><xsl:value-of select='./@n' /><xsl:text>. </xsl:text><xsl:value-of select='./head' /></h5>
		<xsl:apply-templates />
	</xsl:template>

	<!-- division #5 (div5) -->
	<xsl:template match="div5">
		<h6><xsl:value-of select='./@type' /><xsl:text> </xsl:text><xsl:value-of select='./@n' /><xsl:text>. </xsl:text><xsl:value-of select='./head' /></h6>
		<xsl:apply-templates />
	</xsl:template>

	<!-- paragraph (p) -->
	<xsl:template match="p">
		<xsl:choose>
		<xsl:when test='./@rend = "right"'>
			<p style='text-align:right'><xsl:apply-templates /></p>
		</xsl:when>
		<xsl:when test='./@rend = "center"'>
			<p style='text-align:center'><xsl:apply-templates /></p>
		</xsl:when>
		<xsl:when test='./@rend = "pre"'>
			<pre><xsl:apply-templates /></pre>
		</xsl:when>
		<xsl:otherwise>
			<p><xsl:apply-templates /></p>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- quote (quote) -->
	<xsl:template match="quote">
		<blockquote><xsl:apply-templates /></blockquote>
	</xsl:template>

	<!-- line group (lg) -->
	<xsl:template match="lg">
		<p><xsl:apply-templates /></p>
	</xsl:template>

	<!-- line (l) -->
	<xsl:template match="l">
		<xsl:apply-templates /><br />
	</xsl:template>


	<!-- do nothing templates -->

	<!-- teiheader (do nothing) -->
	<xsl:template match="teiHeader" />
	
	<!-- head (head) -->
	<xsl:template match="head" />

</xsl:stylesheet>
