<?xml version='1.0'?>

<!--

	oss.xsl - a stylesheet to process a list of software
	
	Eric Lease Morgan (emorgan@nd.edu)
	September 1, 2003 - Labor Day
	
-->

<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'>

	<xsl:output
		method='xml'
		omit-xml-declaration='no'
		doctype-public='-//W3C//DTD XHTML 1.0 Transitional//EN'
		doctype-system='http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'
		indent='yes' />

	<xsl:template match='/'>
		<html>
			<head>
				<title><xsl:value-of select='/oss/title' /></title>
				<meta>
					<xsl:attribute name='name'>title</xsl:attribute>
					<xsl:attribute name='content'><xsl:value-of select='/oss/title' /></xsl:attribute>
				</meta>
				<meta>
					<xsl:attribute name='name'>creator</xsl:attribute>
					<xsl:attribute name='content'><xsl:value-of select='/oss/author'/></xsl:attribute>
				</meta>
				<meta>
					<xsl:attribute name='name'>description</xsl:attribute>
					<xsl:attribute name='content'><xsl:value-of select='/oss/scope_note' /></xsl:attribute>
				</meta>
				<meta>
					<xsl:attribute name='name'>date</xsl:attribute>
					<xsl:attribute name='content'><xsl:value-of select='/oss/date_updated'/></xsl:attribute>
				</meta>
			</head>
			<body>
				<h1><xsl:value-of select='/oss/title' /></h1>
				<p><xsl:value-of select='/oss/scope_note' /></p>
				<ul>
					<xsl:for-each select='/oss/package'>
						<li>
							<a> 
								<xsl:attribute name='href'><xsl:value-of select='./url' /></xsl:attribute>
								<xsl:value-of select='./title' />
							</a> - <xsl:value-of select='./description' />
						</li>
					</xsl:for-each>
				</ul>
				<hr />
				<small>
					Author: <xsl:value-of select='/oss/author'/> (<a><xsl:attribute name='href'>mailto:<xsl:value-of select='/oss/author/@email'/></xsl:attribute><xsl:value-of select='/oss/author/@email'/></a>)<br />
					Date updated: <xsl:value-of select='/oss/date_updated'/>
				</small>
			</body>
		</html>
	</xsl:template>
	
</xsl:stylesheet>
