#!/usr/bin/perl

# manage-locaions.pl - a sample MyLibrary script to create, find, edit, and delete location types

# Eric Lease Morgan <emorgan@nd.edu>

# 2006-01-11 - wrote pod
# 2003-10-10 - first cut

=head1 NAME

manage-locations.pl - a MyLibrary script to create, find, edit, and delete location types

=head1 DESCRIPTION

Like manage-facets.pl, this program only creates, finds, edits, and deletes location types from a MyLibrary implementation. It is imperitive each information resource be associated with at least one location, and each location must be associated with a location type. Otherwise users will not be able to get to the information resource. "How would a patron get to a book without a call number? How would a Web browser be useful without a URL?" This script provides places to create classes of locations such as call numbers or URL's.

=head1 KNOWN BUGS

The delete function has got not to work since it tries to create a location object with the MyLibrary::Facet module. Dumb!

=head1 SEE ALSO

subroutines.pl

=head1 AUTHOR

Eric Lease Morgan

=cut

# include the necessary modules
use lib '../lib/';
use MyLibrary::Resource::Location;
use strict;
require 'subroutines.pl';

# display an introduction
&clearScreen;
print "\nUse this program to create and maintain MyLibrary location types.\n\n";

# initialize menu choice
my $choice eq '';

do {

	# display menu
	print "Location types main menu\n";
	print "========================\n";
	print <<EOM;
[c]reate a location type
[f]ind all location types
[e]dit a location type
[d]elete a location type
  
[q]uit
  
EOM
	print "Which one? "; chop ($choice = <STDIN>);
	
	# branch according to chioice; create a location
	if ($choice eq 'c') {
	
		# get the input
		print "What is the name of this location type? "; chop (my $name = <STDIN>);
		print "Please describe this type. "; chop (my $note = <STDIN>);
		
		# create the object, fill it, and save it
		MyLibrary::Resource::Location->location_type(action => 'set', name => $name, description => $note);
			
	}
	
	# find all locations
	elsif ($choice eq 'f' ) { &listAllLocations	}
	
	# edit a location
	elsif ($choice eq 'e' ) {
	
		# get the location to edit
		print "What is the ID of the location type you want to edit? "; chop (my $id = <STDIN>);
		
		# get it
		my $location = MyLibrary::Resource::Location->new(id => $id);
		
		# check for success
		if ($location ne undef) {
		
			# get new input
			print "Change the name of the location type from " . $location->location_name . " to: "; chop (my $name = <STDIN>);
			print "Change the note of the location type from " . $location->location_note . " to: "; chop (my $note = <STDIN>);
			
			# update the object
			$location->location_name($name);
			$location->location_note($note);
			$location->commit;

			# echo the result
			&listOneLocationType ($location->location_id);
			
		}
		
		# error
		else { print "The id, $id, does not point to a valid location. Try find.\n" }
	
	}
	
	# delete a location
	elsif ($choice eq 'd' ) {
	
		# get the location to delete
		print "What is the ID of the location you want to delete? "; chop (my $id = <STDIN>);
		
		# get it
		my $location = MyLibrary::Facet->new (id => $id);
		
		# check for success
		if ($location ne undef) {
		
			# display 
			print "\nFacet:\n";
			print "    id = " . $location->location_id . "\n";
			print "  name = " . $location->location_name . "\n";
			print "  note = " . $location->location_note . "\n";
			print "\n";

			# confirm
			print "Do you really want to delete this record [y/n]? "; chop (my $reply = <STDIN>);
			
			# check reply
			if ($reply eq 'y') {
			
				# delete it
				$location->delete;
				print "Facet deleted.\n";
				
			}
			
		}
		
		# error
		else {
		
			print "The id, $id, does not point to a valid location. Try find.\n";
			
		}
	
	}
	
	# quit
	elsif ($choice eq 'q' ) {
	
		print "\nBye, bye\n";
	
	}
	
	else {
		
		print "Unknown choice: $choice. Returning to menu.\n";
	
	}
	
} until $choice eq 'q';


