#!/usr/bin/perl

# index-resources.pl - create a (swish-e) index of all the resources

# Eric Lease Morgan <emorgan@nd.edu>

# 2006-01-12 - added pod
# 2004-10-11 - first cut

=head1 NAME

index-resources.pl - create a (swish-e) index of all MyLibrary resources

=head1 DESCRIPTION

This script runs another script (./resources2swish.pl) and pipes the output to an indexer (swish-e). The indexer is run using a specfic configuration file (./index-resources.cfg). The result should be two new files representing the index (./resources.idx and ./resources.idx.prop). These files are then used by ./search.pl to provide free-text searching against your collection of information resources.

The indexer is expected to be in your PATH.

=head1 SEE ALSO

index-resources.cfg, resources2swish.pl, search.pl

=head1 AUTHOR

Eric Lease Morgan

=cut

system ("./resources2swish.pl | swish-e -c index-resources.cfg -S prog -i stdin");

