# this is a very simple (brain-dead) library catalog "application"

# create an items table
DROP TABLE IF EXISTS items;
CREATE TABLE items (
 id INT(3) NOT NULL AUTO_INCREMENT,
 creator VARCHAR(255) NOT NULL default '',
 title VARCHAR(255) NOT NULL default '',
 sort_title VARCHAR(255) NOT NULL default '',
 subjects VARCHAR(255) NOT NULL default '',
 publisher VARCHAR(255) NOT NULL default '',
 date VARCHAR(255) NOT NULL default '',
 call_number VARCHAR(255) NOT NULL default '',
 extent VARCHAR(255) NOT NULL default '',
 notes VARCHAR(255) NOT NULL default '',
 responsibility VARCHAR(255) NOT NULL default '',
 PRIMARY KEY (id)
);

# insert bunches o' data
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Abraham, Gerald ', 'The concise Oxford history of music', 'concise Oxford history of music', 'Music; History and criticism; ', 'Oxford University Press', '1979', 'ML160 .A27', '968 p. : ill., music ; 26 cm.', 'Gerald Abraham. Includes index. Bibliography: p. 864-912. ', 'Gerald Abraham.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ackermann, Robert John ', 'Belief and knowledge', 'Belief and knowledge', 'Belief and doubt; ', 'Anchor Books', '1972', 'BD215 .A27', '149 p. 19 cm.', 'by Robert J. Ackermann. Bibliography: p. [137]-145. ', 'by Robert J. Ackermann.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Adler, Mortimer Jerome McGill, V. J. (Vivian Jerauld) ', 'Biology, psychology, and medicine', 'Biology, psychology, and medicine', 'Biology; Outlines, syllabi, etc; Psychology; Outlines, syllabi, etc; Mind and body; ', 'Encyclopedia Britannica', '[1963]', 'AC1 .G74 1959 vol. 9', 'xx, 395 p. illus. 22 cm.', 'by Moritmer J. Adler and V. J. McGill. Pref. by Franz Alexander. Bibliography: p. 385-395. ', 'by Moritmer J. Adler and V. J. McGill. Pref. by Franz Alexander.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Adler, Mortimer Jerome Wolff, Peter ', 'The development of political theory and government', 'development of political theory and government', 'Political science; ', 'Encyclopedia Britannica', '1959', 'AC1 .G74 1959 vol. 2', '225 p. 21 cm.', 'by Mortimer J. Adler and Peter Wolff. Pref. by William Benton. Bibliography: p. 222-225. ', 'by Mortimer J. Adler and Peter Wolff. Pref. by William Benton.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Adler, Mortimer Jerome Cain, Seymour ', 'Ethics, the study of moral values', 'Ethics, the study of moral values', 'Ethics; ', 'Encyclopaedia Britannica', '[c1962]', 'AC1 .G74 1959 vol. 8', 'xxii, 319 p. 21 cm.', 'by Mortimer J. Adler and Seymour Cain. Pref. by William Ernest Hocking. Bibliography: p. 305-319. ', 'by Mortimer J. Adler and Seymour Cain. Pref. by William Ernest Hocking.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Adler, Mortimer Jerome Wolff, Peter ', 'Foundations of science and mathematics', 'Foundations of science and mathematics', 'Science; Study and teaching; Science; Methodology; Science; History; Physics; History; Mathematics; History; ', 'Encyclopaedia Britannica', '1960', 'AC1 .G74 1959 vol. 3', 'xxii, 233 p. illus. 22 cm.', 'by Mortimer J. Adler and Peter Wolff. Pref. by Curtis Wilson. A reading plan for "Great books of the Western World." Bibliography: p. 225-233. ', 'by Mortimer J. Adler and Peter Wolff. Pref. by Curtis Wilson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Adler, Mortimer Jerome Wolff, Peter ', 'A general introduction to the great books and to a liberal education', 'general introduction to the great books and to a liberal education', '', 'Encyclopaedia Britannica', '1959', 'AC1 .G74 1959 vol. 1', '195 p. 21 cm.', 'by Mortimer J. Adler and Peter Wolff. With a pref. by Robert M. Hutchins. Cover title: An introduction to the great books and to a liberal education. Bibliography: p. 192-195. ', 'by Mortimer J. Adler and Peter Wolff. With a pref. by Robert M. Hutchins.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Adler, Mortimer Jerome Van Doren, Charles Lincoln ', 'How to read a book', 'How to read a book', 'Reading; ', 'Simon and Schuster', '[1972]', 'PN83 .A43 1972', 'xiii, 426 p. 22 cm.', 'by Mortimer J. Adler and Charles van Doren. Bibliography: p. 347-362. ', 'by Mortimer J. Adler and Charles van Doren.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Adler, Mortimer Jerome Cain, Seymour ', 'Imaginative literature', 'Imaginative literature', 'Literature; History and criticism; Literature; Study and teaching; ', 'Encyclopedia Britannica', '[c1961-62]', 'AC1 .G74 1959 vols. 6-7', '2 v. maps, plan. 21 cm.', 'by Mortimer J. Adler and Seymour Cain. Bibliography: v. 1, p. 234-237; v. 2, p. 249-254. ', 'by Mortimer J. Adler and Seymour Cain.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Adler, Mortimer Jerome Cain, Seymour ', 'Philosophy', 'Philosophy', 'Philosophy; Introductions; ', 'Encyclopaedia Britannica, inc.', '[1963]', 'AC1 .G74 1979 vol. 10', 'xxi, 308 p. diagrs. 22 cm.', 'by Mortimer J. Adler and Seymour Cain. Pref. by Richard McKeon. Bibliography: p. 303-308. ', 'by Mortimer J. Adler and Seymour Cain. Pref. by Richard McKeon.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Adler, Mortimer Jerome Wolff, Peter ', 'Philosophy of law and jurisprudence', 'Philosophy of law and jurisprudence', 'Law; Philosophy; Jurisprudence; ', 'Encyclopaedia Britannica', '[1961]', 'AC1 .G74 1959 vol. 5', 'xx, 251 p. 21 cm.', 'by Mortimer J. Adler and Peter Wolff. Pref. by Edward H. Levi. Bibliography: p. 240-251. ', 'by Mortimer J. Adler and Peter Wolff. Pref. by Edward H. Levi.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Adler, Mortimer Jerome Cain, Seymour ', 'Religion and theology', 'Religion and theology', 'Christian literature; History and criticism; Religious literature; History and criticism; ', 'Encyclopaedia Britannica', '1961', 'AC1 .G74 vol. 4', 'xxviii, 278 p. 21 cm.', 'Prefaces by John Cogley [and others]. Bibliography: p. 271-278. ', 'Prefaces by John Cogley [and others].');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Agay, Denes, [from old catalog] ', 'The joy of Baroque', 'joy of Baroque', 'Piano music; to 1800. [from old catalog]; Piano music, Juvenile. [from old catalog]; ', '', '[1974]', 'M21.A225 J73', '80 p. ; 31 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ahmed, Kal. ', 'Professional XML meta data', 'Professional XML meta data', 'XML (Document markup language); Metadata; ', 'Wrox Press', '2001', 'QA76.76.H94 .P767 2001', 'ix, 567 p. : ill. ; 23 cm.', 'Kal Ahmed ... [et al.] "Programmer to programmer." Includes bibliographical references and index. ', 'Kal Ahmed ... [et al.]');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Aiken, Henry David ', 'The age of ideology', 'age of ideology', 'Philosophy, Modern; Ideology; History; ', 'Books for Libraries Press', '[1970, c1956]', 'B803 .A35 1970', '283 p. 23 cm.', 'Selected, with introd. and interpretive commentary, by Henry D. Aiken. Bibliography: p. 275-277. ', 'Selected, with introd. and interpretive commentary, by Henry D. Aiken.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Alberico, Ralph. Micco, Mary. ', 'Expert systems for reference and information retrieval', 'Expert systems for reference and information retrieval', 'Expert systems (Computer science); Reference services (Libraries); Automation; Information retrieval; ', 'Meckler', 'c1990', 'Z678.93.E93 A4 1990', 'xiii, 395 p. : ill. ; 24 cm.', 'Ralph Alberico and Mary Micco. Includes bibliographical references (p. [343]-383) and index. ', 'Ralph Alberico and Mary Micco.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Alexander, Lloyd. ', 'The castle of Llyr', 'castle of Llyr', 'Fantasy; ', 'H. Holt', 'c1999', 'PZ7.A3774 Cas 1999', 'ix, 172 p. : map ; 24 cm.', 'Lloyd Alexander. ', 'Lloyd Alexander.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Alfassy, Leo. [from old catalog] ', 'Baroque & folk tunes for recorder', 'Baroque & folk tunes for recorder', 'Recorder music, arranged. [from old catalog]; Folk-songs (Instrumental settings) [from old catalog]; ', ': Amsco Music Publishing co.', '1975', 'M63 .B365', '87 p. ; 28 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Alfred A. Knopf, Inc ', 'Rome', 'Rome', 'Maps; Maps, Tourist; Guidebooks; Central business districts; Guidebooks; Subways; Guidebooks; ', 'Alfred A. Knopf', 'c2001', 'G1989.R7 R6 2001', '1 atlas (A-F) : col. ill., col. maps (folded) ; 17 cm.', 'Cover title. "This ia a Borzoi book"--Verso of cover. "Originally published in France by Nouveaux Loisirs ... 2000"--Verso of cover. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Allen, Terese. ', 'The Ovens of Brittany cookbook', 'Ovens of Brittany cookbook', 'Cookery, French; ', 'Amherst Press', 'c1991', 'TX719 .A44 1991', 'xviii, 126 p. ; 26 cm.', 'by Terese Allen. Includes index. ', 'by Terese Allen.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Allen, Warren Dwight ', 'Philosophies of music history', 'Philosophies of music history', 'Music; Historiography; Music; Bibliography; ', 'Dover Publications', '[c1962]', 'ML3800.A43 P5 1962', '382 p. illus. 22 cm.', 'Includes bibliographies. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Alston, William P. Brandt, Richard B. ', 'The problems of philosophy', 'problems of philosophy', 'Philosophy; ', 'Allyn and Bacon', '[1967]', 'B21 .A45', 'ix, 722 p. 24 cm.', 'edited by William P. Alston and Richard B. Brandt. Includes bibliographies. ', 'edited by William P. Alston and Richard B. Brandt.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Aluri, Rao. Riggs, Donald E. ', 'Expert systems in libraries', 'Expert systems in libraries', 'Expert systems (Computer science); Libraries; Automation; ', 'Ablex Pub. Corp.', 'c1990', 'Z678.93.E93 E94 1990', 'viii, 342 p. : ill. ; 24 cm.', 'edited by Rao Aluri and Donald E. Riggs. Includes bibliographical references (p. 310-331) and indexes. ', 'edited by Rao Aluri and Donald E. Riggs.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Anderson, Gail Anderson, Paul ', 'The UNIX C shell field guide', 'UNIX C shell field guide', '', 'Prentice Hall', 'c1986', 'QA76.76.O63 A53 1986', 'xxi, 374 p. ; 24 cm.', 'Gail Anderson, Paul Anderson. Includes index. ', 'Gail Anderson, Paul Anderson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('', 'The best American recipes', 'best American recipes', 'Cookery, American; Periodicals; ', 'Houghton Mifflin Co.', '1999-', 'TX1 .B455', 'v. : ill. ; 27 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('', 'Carolina thyme', 'Carolina thyme', '', 'Junior League of Durham and Orange Counties', 'c2001', '*', '270 p. ; 27 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('', 'Django Reinhardt', 'Django Reinhardt', '', '', 'c1978', 'M1 .M8772 vol. 83', '71 p. ; 31 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('', 'Frommers Rome', 'Frommers Rome', 'Guidebooks; ', 'Macmillan', 'c1997-', 'DG804 .F79', 'v. : maps ; 22 cm.', '"A Frommer book." ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('', 'A guide to the natural world', 'guide to the natural world', 'Natural history; Handbooks, manuals, etc; Life nature library; Indexes; ', 'Time, inc.', '[1965]', 'QH53 .L53', '210 p. illus. (part col.) 28 cm.', 'By the editors of Life. ', 'By the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('', 'The insiders guide to North Carolinas Outer Banks', 'insiders guide to North Carolinas Outer Banks', 'Guidebooks; ', 'Insiders Guides, Inc.', 'c1992-', 'F262.O96 I53', 'v. : ill., maps ; 21 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('', 'The New Encyclopaedia Britannica', 'New Encyclopaedia Britannica', 'Encyclopedias and dictionaries; ', 'Encyclopaedia Britannica', 'c1981', 'AE5 .E363 1981', '30 v. : ill. (some col.) ; 29 cm.', 'Spine title: Encyclopaedia Britannica. Includes bibliographies. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Apel, Willi ', 'Harvard dictionary of music', 'Harvard dictionary of music', 'Music; Dictionaries; ', 'Harvard university press', '1944', 'ML100 .A64', 'x, 824 p. illus. (incl. music) 24 cm.', 'by Willi Apel. Restricted to musical topics, omitting biographical articles. cf. p. v. Includes bibliographies. ', 'by Willi Apel.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Arden, William Arthur, Robert. Hearne, Jack ', 'Alfred Hitchcock and the three investigators in The mystery of the shrinking house', 'Alfred Hitchcock and the three investigators in The mystery of the shrinking house', 'Mystery and detective stories; ', 'Random House', '[1972]', 'PZ7.L984 Am', '153 p. illus. 22 cm.', 'Text by William Arden. Based on characters created by Robert Arthur. Illustrated by Jack Hearne. ', 'Text by William Arden. Based on characters created by Robert Arthur. Illustrated by Jack Hearne.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Arendt, Hannah. ', 'Thinking', 'Thinking', 'Thought and thinking; Philosophy; ', 'Harcourt Brace Jovanovich', 'c1978', 'B29 .A73 vol. 1', 'xii, 258 p. ; 25 cm.', 'Hannah Arendt. Includes bibliographical references and index. ', 'Hannah Arendt.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Armour, Leslie ', 'The concept of truth', 'concept of truth', 'Truth; ', 'Van Gorcum', '1969', 'BD171 .A7', '266 p. 24 1/2 cm.', 'Bibliographical footnotes. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Arnheim, Rudolf. ', 'Visual thinking', 'Visual thinking', 'Visual perception; Art; Philosophy; ', 'University of California Press', '[1969]', 'N70 .A693', 'xi, 345 p. illus. (part col.) 26 cm.', 'Bibliography: p. 325-338. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Arnold, Mark. ', 'Administering Apache', 'Administering Apache', 'Web servers; Computer programs; ', 'McGraw-Hill', '2000', 'TK5105.8885.A63 A76 2000', 'xiv, 513 p. : ill. ; 24 cm.', 'Mark Arnold. Includes index. ', 'Mark Arnold.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Aronson, Larry. ', 'HTML manual of style', 'HTML manual of style', 'Hypertext systems; HTML (Document markup language); ', 'Ziff-Davis Press', 'c1994', 'QA76.76.H94 A76 1994', 'ix, 132 p. : ill. ; 23 cm.', 'Larry Aronson. Includes index. ', 'Larry Aronson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Arthur, Robert. ', 'Alfred Hitchcock and the Three Investigators in the mystery of the whispering mummy', 'Alfred Hitchcock and the Three Investigators in the mystery of the whispering mummy', '', 'Random House', '[c1965]', 'PZ7.A744 Aj', '185 p. illus. 22 cm.', 'Illustrated by Harry Kane. ', 'Illustrated by Harry Kane.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Arthur, Robert. ', 'Alfred Hitchcock and the Three Investigators in The mystery of the silver spider', 'Alfred Hitchcock and the Three Investigators in The mystery of the silver spider', '', 'Random House', '[1967]', 'PZ7.A744 Ahd', '184 p. illus. 22 cm.', 'Illustrated by Harry Kane. ', 'Illustrated by Harry Kane.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Arthur, Robert. ', 'Alfred Hitchcock and the three investigators in The mystery of the fiery eye', 'Alfred Hitchcock and the three investigators in The mystery of the fiery eye', 'Mystery and detective stories; ', 'Random House', '[1967]', 'PZ7.A744 Ag', 'viii, 180 p. illus. 22 cm.', 'Illustrated by Harry Kane. ', 'Illustrated by Harry Kane.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Arthur, Robert. Kane, Harry ', 'Alfred Hitchcock and the three investigators in The mystery of the talking skull', 'Alfred Hitchcock and the three investigators in The mystery of the talking skull', 'Mystery and detective stories; ', 'Random House', '[1969]', 'PZ7.A744 Ahg', 'viii, 179 p. illus. 22 cm.', 'Illustrated by Harry Kane. ', 'Illustrated by Harry Kane.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ashe, Geoffrey. Debretts Peerage Limited ', 'The discovery of King Arthur', 'discovery of King Arthur', 'Homes and haunts; Britons; Kings and rulers; Folklore; Antiquities, Celtic; History; Arthurian romances; Sources; ', 'Anchor Press/Doubleday', '1985', 'DA152.5.A7 A793 1985', 'xi, 226 p., [26] p. of plates : ill. ; 24 cm.', 'Geoffrey Ashe in association with Debretts Peerage. Includes index. Bibliography: p. [211]-215. ', 'Geoffrey Ashe in association with Debretts Peerage.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Asimov, Isaac ', 'Asimovs Guide to the Bible', 'Asimovs Guide to the Bible', 'History of Biblical events; Criticism, interpretation, etc; ', 'Avenel Books Distributed by Crown Publishers', '[1981] c1968-1969', 'BS635.2 .A8 1981', '1295 p. : maps ; 24 cm.', 'Isaac Asimov ; maps by Rafael Palacios. Reprint. Originally published in 2 v.: Garden City, N.Y. : Doubleday, 1968-1969. Includes indexes. ', 'Isaac Asimov ; maps by Rafael Palacios.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Auel, Jean M. ', 'The shelters of stone', 'shelters of stone', 'Ayla (Fictitious character); Fiction; Prehistoric peoples; Fiction; Glacial epoch; Fiction; Fiction; ', 'Crown', '2002', 'PS3551.U36 S54 2002', 'xii, 753 p. : maps ; 25 cm.', 'Jean M. Auel. ', 'Jean M. Auel.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ayeroff, Stan. [from old catalog] ', 'Charlie Christian', 'Charlie Christian', 'Guitar music, Arranged. [from old catalog]; Guitar music (Jazz) [from old catalog]; ', '', 'c1979', 'M1 .M8772 vol. 84', '70 p. ; 31 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ayer, A. J. (Alfred Jules) ', 'The problem of knowledge', 'problem of knowledge', 'Knowledge, Theory of; ', 'Macmillan', '1956', 'BD161 .A9', '258 p. 23 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bach, Johann Sebastian Novack, Saul. ', 'The well-tempered clavier', 'well-tempered clavier', 'Harpsichord music; Canons, fugues, etc. (Harpsichord); ', 'Dover Publications', '1983', 'M22.B11 W656 1983', '202 p. of music ; 32 cm.', 'Johann Sebastian Bach. Preludes and fugues; for harpsichord. Reprint. Originally published: Leipzig : Bach-Gesellschaft, 1866. (Johann Sebastian Bachs Werke ; Jahrg. 14) With corrections and explanation of ornaments by Saul Novack. ', 'Johann Sebastian Bach.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Baglio, Ben M. Butler, John. Copyright Paperback Collection (Library of Congress) ', 'Cats in the castle', 'Cats in the castle', '', 'Scholastic', '2003, c2001', 'CPB Box no. 2022 vol. 8', '129 p. : ill. ; 20 cm.', 'Ben M. Baglio ; illustrations by John Butler. "An Apple paperback." ', 'Ben M. Baglio ; illustrations by John Butler.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Baker, Christopher P. Lonely Planet Publications (Firm) ', 'Jamaica', 'Jamaica', 'Guidebooks; ', 'Lonely Planet Publications', '1996-', 'F1869 .J29523', 'v. : ill. (some col.), maps ; 19 cm.', 'Written by: C. Baker. At head of title: Lonely Planet, <2000-> Published: Footscray, Vic., 2000- Vols. for 2000-   lack series title. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Barber, E. Gordon (Edward Gordon) ', 'Pictorial composition in monochrome and colour', 'Pictorial composition in monochrome and colour', 'Photography, Artistic; Composition (Art); ', 'The Fountain press', '[1946]', 'TR650 .B27 1946', '104 p. incl. illus., plates, diagrs. 19 cm.', 'At head of title: E. Gordon Barber. "First edition, February 1942. Second edition, January 1946. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Barkakati, Nabajyoti ', 'Red Hat Linux 7.1 secrets', 'Red Hat Linux 7.1 secrets', 'Operating systems (Computers); ', 'Hungry Minds', '2001', 'QA76.76.O63 B366166 2001', 'xxxiv, 1135 p. : ill. ; 24 cm. + 3 computer optical discs (4 3/4 in.)', 'Naba Barkakati. Includes bibliographical references and index. ', 'Naba Barkakati.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Barrett, William Aiken, Henry David ', 'Philosophy in the twentieth century', 'Philosophy in the twentieth century', 'Philosophy, Modern; ', 'Random House', '[1962]', 'B804 .B36 1962', '4 v. 23 cm.', 'Edited and with introductions by William Barrett and Henry D. Aiken. Bibliographical footnotes. ', 'Edited and with introductions by William Barrett and Henry D. Aiken.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bartlett, John ', 'Familiar quotations', 'Familiar quotations', 'Quotations, English; ', 'Little, Brown', '[1955]', 'PN6081 .B27 1955', 'xxxiv, 1614 p. 25 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bates, Marston ', 'The land and wildlife of South America', 'land and wildlife of South America', 'Natural history; ', 'Time inc.', '[1964]', 'QH111 .B42', '200 p. illus. (part col.) col. maps. 29 cm.', 'by Marston Bates and the editors of Life. Bibliography: p. 195. ', 'by Marston Bates and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bauer, George Howard ', 'Sartre and the artist', 'Sartre and the artist', 'Characters; Artists; Art and literature; History; Artists in literature; ', 'University of Chicago Press', '[1969]', 'PQ2637.A82 Z56', 'x, 200 p. illus., ports. 24 cm.', 'Based on the authors thesis, Indiana University. Bibliography: p. [185]-192. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bayless, Rick. Bayless, Deann Groen. Brownson, JeanMarie. ', 'Rick Baylesss Mexican kitchen', 'Rick Baylesss Mexican kitchen', 'Cookery, Mexican; ', 'Scribner', 'c1996', 'TX716.M4 B295 1996', '448 p. : ill. (some col.) ; 25 cm.', 'with Deann Groen Bayless and JeanMarie Brownson ; photographs by Maria Robledo ; illustrations by John Sandford. Includes bibliographical references (p. 428) and index. ', 'with Deann Groen Bayless and JeanMarie Brownson ; photographs by Maria Robledo ; illustrations by John Sandford.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Beard, James ', 'The fireside cook book', 'fireside cook book', 'Cookery, American; ', 'Simon and Schuster', '1949', 'TX715 .B37', '322 p. col. illus. 26 cm.', 'With illus. by Alice and Martin Provensen. ', 'With illus. by Alice and Martin Provensen.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Beiser, Arthur. ', 'The earth', 'earth', '', 'Time, inc.', '[1962]', 'QB631 .B38', '192 p. illus. (part col.) col. map. 28 cm.', 'by Arthur Beiser and the editors of Life. Bibliography: p. 185. ', 'by Arthur Beiser and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bell, Clive ', 'Art', 'Art', 'Art; Art; History; Aesthetics; ', 'Capricorn Books', '[1958]', 'N7445 .B53 1958', '190 p. 19 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Benjamin, Harold Raymond Wayne ', 'An introduction to human problems', 'introduction to human problems', 'Classification of sciences. [from old catalog]; Methodology. [from old catalog]; ', 'Houghton Mifflin company', '[1930]', 'BD241 .B4', 'xiii, 472 p. diagrs. 22 cm.', 'by Harold Benjamin ... ', 'by Harold Benjamin ...');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bergamini, David ', 'The land and wildlife of Australia', 'land and wildlife of Australia', 'Natural history; ', 'Time, inc.', '[1964]', 'QH197 .B44', '198 p. illus. (part col.) maps (part col.) 28 cm.', 'by David Bergamini and the editors of Life. Revised ed. published as: The land and wildlife of Australasia. c1980. Bibliography: p. 193. ', 'by David Bergamini and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Berlin, Isaiah ', 'The Age of Enlightenment', 'Age of Enlightenment', 'Enlightenment; Philosophy, Modern; ', 'Books for Libraries Press', '[1970, c1956]', 'B802 .B45 1970', '282 p. 23 cm.', 'Selected, with introd. and interpretive commentary by Isaiah Berlin. Bibliography: p. 278-280. ', 'Selected, with introd. and interpretive commentary by Isaiah Berlin.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Berry, Brewton. ', 'Race and ethnic relations', 'Race and ethnic relations', 'Race relations; Ethnic relations; ', 'Houghton Mifflin', '[1965]', 'HT1521 .B45 1965', 'ix, 435 p. illus. 24 cm.', 'First ed. published in 1951 under title: Race relations. Bibliography: p. 404-418. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Berry, Arthur ', 'A short history of astronomy', 'short history of astronomy', 'Astronomy; History; ', 'Dover Publications', '1961', 'QB15 .B53 1961', 'xxxi, 440 p., [25] leaves of plates : ill. ; 21 cm.', 'by Arthur Berry. Includes bibliographical references (p. 411-416) and indexes. ', 'by Arthur Berry.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bittman, Mark. ', 'The minimalist cooks at home', 'minimalist cooks at home', 'Cookery; Quick and easy cookery; ', 'Broadway Books', 'c1999', 'TX714 .B57323 1999', '248 p. : ill. ; 25 cm.', 'Mark Bittman. Includes index. ', 'Mark Bittman.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('BonJour, Laurence ', 'The structure of empirical knowledge', 'structure of empirical knowledge', 'Knowledge, Theory of; Empiricism; ', 'Harvard University Press', '1985', 'BD161 .B59 1985', 'xiii, 258 p. ; 25 cm.', 'Laurence BonJour. Includes index. Bibliography: p. 251-254. ', 'Laurence BonJour.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Boole, George ', 'An investigation of the laws of thought', 'investigation of the laws of thought', 'Logic, Symbolic and mathematical. [from old catalog]; Thought and thinking. [from old catalog]; Probabilities. [from old catalog]; ', 'Dover Publications', '[1951]', 'BC135 .B7 1951', '424 p. port. 21 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Boorstin, Daniel J. (Daniel Joseph) Daniel J. Boorstin Collection (Library of Congress) ', 'The discoverers', 'discoverers', 'Civilization; History; Discoveries in geography; Science; History; ', 'Vintage Books', '1985, c1983', 'CB69 .B66 1985', 'xvi, 745 p. ; 21 cm.', 'Daniel J. Boorstin. Includes index. Bibliography: p. [685]-713. ', 'Daniel J. Boorstin.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Booth, Letha Colonial Williamsburg Foundation ', 'The Williamsburg cookbook', 'Williamsburg cookbook', 'Cookery; ', 'The Colonial Williamsburg Foundation', '1975', 'TX715 .B725 1975', '172 p., [6] leaves of plates : ill. ; 27 cm.', 'initially compiled and adapted by Letha Booth and the staff of Colonial Williamsburg ; with commentary by Joan Parry Dutton ; color photos. by Taylor Biggs Lewis, Jr. ; line drawings by Vernon Wooten. Includes index. ', 'initially compiled and adapted by Letha Booth and the staff of Colonial Williamsburg ; with commentary by Joan Parry Dutton ; color photos. by Taylor Biggs Lewis, Jr. ; line drawings by Vernon Wooten.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Borko, Harold. Bernier, Charles L. ', 'Abstracting concepts and methods', 'Abstracting concepts and methods', 'Abstracting; ', 'Academic Press', '1975', 'Z695.9 .B65', 'x, 250 p. ; 24 cm.', 'Harold Borko, Charles L. Bernier. Includes index. Bibliography: p. 219-223. ', 'Harold Borko, Charles L. Bernier.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Botkin, Benjamin Albert ', 'A Treasury of American folklore', 'Treasury of American folklore', 'Folklore; Legends; Social life and customs; ', 'American Legacy Press', '[1989], c1944', 'GR105 .T73 1989', 'xxvii, 932 p. : ill. ; 24 cm.', 'edited by B.A. Botkin ; with a foreword by Carl Sandburg. Reprint. Originally published: New York : Crown Publishers, 1944. Includes bibliographical references and index. ', 'edited by B.A. Botkin ; with a foreword by Carl Sandburg.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bowman, Judith S. Emerson, Sandra L. Darnovsky, Marcy. ', 'The practical SQL handbook', 'practical SQL handbook', 'SQL (Computer program language); Relational databases; ', 'Addison-Wesley Developers Press', 'c1996', 'QA76.73.S67 B69 1996', 'xxvi, 454 p. : ill. ; 26 cm. + 1 computer disk.', 'Judith S. Bowman, Sandra L. Emerson, and Marcy Darnovsky. Includes bibliographical references (p. 439-441) and index. ', 'Judith S. Bowman, Sandra L. Emerson, and Marcy Darnovsky.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bradley, Sculley Beatty, Richmond Croom Long, E. Hudson (Eugene Hudson) ', 'The American tradition in literature', 'American tradition in literature', 'American literature; Civilization; Literary collections; ', 'Norton', '[1967]', 'PS507 .B74 1967', '2 v. 22 cm.', 'edited by Sculley Bradley, Richmond Croom Beatty [and] E. Hudson Long. Bibliography: v.1, 1762-1766; v.2, p. 1724-1727. ', 'edited by Sculley Bradley, Richmond Croom Beatty [and] E. Hudson Long.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Brands, H. W. ', 'The age of gold', 'age of gold', 'Gold discoveries; Gold discoveries; Social aspects; Civilization; Social conditions; ', 'Doubleday', '2002', 'F865 .B76 2002', '547 p., [16] p. of plates : ill., maps ; 24 cm.', 'H.W. Brands. Includes bibliographical references (p. [509]-527) and index. ', 'H.W. Brands.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Brennan, Georgeanne Williams, Chuck. Eskite, Richard. ', 'Casual outdoor dining', 'Casual outdoor dining', 'Outdoor cookery; ', 'Time-Life Books', 'c1998', 'TX823 .B69 1998', '111 p. : ill. (some col.) ; 26 cm.', 'general editor, Chuck Williams ; recipes, Georgeanne Brennan ; photography, Richard Eskite. Includes index. ', 'general editor, Chuck Williams ; recipes, Georgeanne Brennan ; photography, Richard Eskite.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Brinck, Tom. Gergle, Darren. Wood, Scott D. ', 'Designing Web sites that work', 'Designing Web sites that work', 'Web sites; Design; Computer software; Human factors; ', 'Morgan Kaufmann Publishers', 'c2002', 'TK5105.888 .B763 2002', 'xiii, 481 p. : ill. (some col.) ; 24 cm.', 'Tom Brink, Darren Gergle, Scott D. Wood. Includes bibliographical references (p. 452-458) and index. ', 'Tom Brink, Darren Gergle, Scott D. Wood.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Brody, Jane E. ', 'Jane Brodys Good food book', 'Jane Brodys Good food book', 'High-carbohydrate diet; Recipes; ', 'Norton', 'c1985', 'RM237.59 .B76 1985', 'xxviii, 700 p. : ill. ; 25 cm.', 'by Jane E. Brody ; illustrations by Ray Skibinski. Includes index. ', 'by Jane E. Brody ; illustrations by Ray Skibinski.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bronowski, Jacob ', 'The ascent of man', 'ascent of man', 'Science; Philosophy; Science; History; Human beings; ', 'Little, Brown', '[1974, c1973]', 'Q175 .B7918 1974', '448 p. illus. 26 cm.', '[by] J. Bronowski. Bibliography: p. 440-442. ', '[by] J. Bronowski.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bronowski, Jacob ', 'The common sense of science', 'common sense of science', 'Science; Philosophy; ', 'Heinemann', '[1951]', 'Q175 .B792', '154 p. 19 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bronowski, Jacob ', 'Science and human values', 'Science and human values', 'Science; ', 'Harper & Row', '[1965]', 'Q171 .B8785 1965', 'xiv, 119 p. illus. 21 cm.', '"The three essays which make up Science and human values were first given as lectures at the Massachusetts Institute of Technology on 26 February, 5 March and 19 March 1953." The dialogue was originally broadcast by the BBC Third programme in 1962. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bronowski, Jacob Ariotti, Piero E. Bronowski, Rita. ', 'The visionary eye', 'visionary eye', 'Arts; Addresses, essays, lectures; Science and the arts; Addresses, essays, lectures; Imagination; Addresses, essays, lectures; ', 'MIT Press', 'c1978', 'NX65 .B696 1978', 'x, 185 p. : ill. ; 24 cm.', 'J. Bronowski ; selected and edited by Piero E. Ariotti in collaboration with Rita Bronowski. Includes index. ', 'J. Bronowski ; selected and edited by Piero E. Ariotti in collaboration with Rita Bronowski.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Brooke, Rosalind B. Brooke, Christopher Nugent Lawrence. ', 'Popular religion in the Middle Ages', 'Popular religion in the Middle Ages', 'Church history; Church history; Religious life and customs; Social history; Popular culture; History; ', 'Thames and Hudson', 'c1984', 'BR738.2 .B76 1984', '176 p. : ill. ; 24 cm.', 'Rosalind and Christopher Brooke. Includes index. Bibliography: p. 157-166. ', 'Rosalind and Christopher Brooke.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Brooke, Christopher Nugent Lawrence. ', 'The structure of medieval society', 'structure of medieval society', 'Social history; Social groups; ', 'McGraw-Hill', '[1971]', 'HN11 .B76', '143 p. illus. (part col.) 22 cm.', '[by] Christopher Brooke. A revision and enlargement of the first chapter in The flowering of the Middle Ages, edited by J. Evans, originally published in 1966. Bibliography: p. 133. ', '[by] Christopher Brooke.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Browder, Walter Browder, Sue Ellin ', '101 secrets a good dad knows', '101 secrets a good dad knows', 'Father and child; Miscellanea; Fathers; Miscellanea; Curiosities and wonders; ', 'Rutledge Hill Press', '2000', 'HQ756 .B78 2000', '239 p. : ill. ; 19 cm.', 'Walter Browder and Sue Ellin Browder ; illustrations by Walter Browder. ', 'Walter Browder and Sue Ellin Browder ; illustrations by Walter Browder.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Brown, Ellen. ', 'The Gourmet Gazelle cookbook', 'Gourmet Gazelle cookbook', 'Reducing diets; Recipes; ', 'Bantam Books', '1989', 'RM222.2 .B783 1989', 'xiv, 333 p. ; 26 cm.', 'Ellen Brown. Includes index. ', 'Ellen Brown.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Brown, Alton ', 'Im just here for the food', 'Im just here for the food', 'Cookery; ', 'Stewart, Tabori & Chang', '2002', 'TX651 .B728 2002', '287 p. : col. ill. ; 24 cm.', 'Alton Brown. Includes index. ', 'Alton Brown.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Brown, John Seely. Duguid, Paul ', 'The social life of information', 'social life of information', 'Information society; Information technology; Social aspects; ', 'Harvard Business School Press', 'c2000', 'HM851 .B76 2000', 'x, 320 p. ; 22 cm.', 'John Seely Brown and Paul Duguid. Includes bibliographical references (p. 289-305) and index. ', 'John Seely Brown and Paul Duguid.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Brown, Edward Espe. ', 'Tomato blessings and radish teachings', 'Tomato blessings and radish teachings', 'Cookery; Cookery; Religious aspects; Zen Buddhism; ', 'Riverhead Books', '1997', 'TX652 .B72 1997', 'xxv, 293 p. ; 25 cm.', 'Edward Espe Brown. Includes index. ', 'Edward Espe Brown.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Brueton, Diana. ', 'Many moons', 'Many moons', 'Popular works; ', 'Prentice Hall Press', 'c1991', 'QB581.9 .B78 1991', '256 p. : ill. (some col.) ; 25 cm.', 'Diana Brueton. Includes bibliographical references (p. 248-250) and index. ', 'Diana Brueton.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Buehrens, John A. Church, F. Forrester. ', 'Our chosen faith', 'Our chosen faith', 'Unitarian Universalist churches; Doctrines; ', 'Beacon Press', 'c1989', 'BX9841.2 .B84 1989', 'xxv, 195 p. ; 18 cm.', 'John A. Buehrens and F. Forrester Church ; with a foreword by William F. Schulz. Includes bibliographical references (p. 193-195). ', 'John A. Buehrens and F. Forrester Church ; with a foreword by William F. Schulz.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Buermeyer, Laurence Ladd ', 'The aesthetic experience', 'aesthetic experience', 'Aesthetics; Art; ', 'The Barnes Foundation', '1924', 'BH201 .B8', '183 p. 20 cm.', 'by Laurence Buermeyer. ', 'by Laurence Buermeyer.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Bukofzer, Manfred F. ', 'Music in the baroque era, from Monteverdi to Bach', 'Music in the baroque era, from Monteverdi to Bach', 'Music; History and criticism; Music; History and criticism; ', 'W. W. Norton', '[1947]', 'ML193 .B8', 'xv, 489 p. illus., ports., facsims., music. 24 cm.', 'Bibliography: p. 417-469. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Buranelli, Vincent. ', 'Edgar Allan Poe', 'Edgar Allan Poe', 'Criticism and interpretation; Fantasy literature, American; History and criticism; ', 'Twayne Publishers', '[1961]', 'PS2638 .B87 1961', '157 p. 21 cm.', 'Includes bibliography. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Burgoyne, John. Tremblay, Carl. ', 'The best recipe', 'best recipe', 'Soups; Stews; Cookery; ', 'Boston Common Press', '2001', '', 'xiii, 350 p. : ill. ; 29 cm.', 'by the editors of Cooks illustrated ; illustrations by John Burgoyne ; photography by Carl Tremblay. Includes index. ', 'by the editors of Cooks illustrated ; illustrations by John Burgoyne ; photography by Carl Tremblay.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Burke, John Frederick ', 'Life in the castle in medieval England', 'Life in the castle in medieval England', 'Castles; History; Social life and customs; Social history; ', 'Rowman and Littlefield', '1978', 'DA660 .B89 1978', '120 p. : ill. ; 26 cm.', 'John Burke. Includes index. Bibliography: p. 118. ', 'John Burke.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Cameron, Debra. Rosenblatt, Bill. ', 'Learning GNU Emacs', 'Learning GNU Emacs', 'Text editors (Computer programs); ', 'OReilly & Associates', 'c1991', 'QA76.76.T49 C35 1991', 'xxvii, 411 p. : ill. ; 23 cm.', 'Debra Cameron and Bill Rosenblatt. "Unix text processing"--Cover. Includes index. ', 'Debra Cameron and Bill Rosenblatt.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Cantor, Norman F. ', 'In the wake of the plague', 'In the wake of the plague', 'Black Death; History; ', 'Free Press', 'c2001', 'RC172 .C36 2001', '245 p., [8] p. of plates : ill., 1 map ; 23 cm.', 'Norman F. Cantor. Includes bibliographical references (p. 221-230) and index. ', 'Norman F. Cantor.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Carey, M. V. Arthur, Robert. Hearne, Jack ', 'Alfred Hitchcock and the three investigators in The secret of the haunted mirror', 'Alfred Hitchcock and the three investigators in The secret of the haunted mirror', 'Mystery and detective stories; ', 'Random House', '[1974]', 'PZ7.C213 Ap', 'viii, 152 p. illus. 22 cm.', 'Text by M. V. Carey. Based on characters created by Robert Arthur. Illustrated by Jack Hearne. ', 'Text by M. V. Carey. Based on characters created by Robert Arthur. Illustrated by Jack Hearne.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Carey, M. V. Arthur, Robert. Kane, Harry ', 'Alfred Hitchcock and the Three Investigators in The mystery of the flaming footprints', 'Alfred Hitchcock and the Three Investigators in The mystery of the flaming footprints', 'Mystery and detective stories; ', 'Random House', '[1971]', 'PZ7.C213 Al', 'viii, 182 p. illus. 22 cm.', 'Text by M. V. Carey. Based on characters created by Robert Arthur. Illustrated by Harry Kane. On spine: The mystery of the flaming footprints. ', 'Text by M. V. Carey. Based on characters created by Robert Arthur. Illustrated by Harry Kane.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Carnegie, Dale ', 'How to win friends and influence people', 'How to win friends and influence people', 'Success; ', 'Simon and Schuster', 'c1981', 'BF637.S8 C37 1981', '299 p. ; 22 cm.', 'Dale Carnegie ; editorial consultant, Dorothy Carnegie, editorial assistance, Arthur R. Pell. Includes bibliographical references and index. ', 'Dale Carnegie ; editorial consultant, Dorothy Carnegie, editorial assistance, Arthur R. Pell.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Carrera, Michael. ', 'Sex', 'Sex', 'Sex (Psychology); ', 'Crown Publishers', 'c1981', 'BF692 .C29 1981', '448 p. : ill. ; 27 cm.', 'Michael Carrera. Includes index. Bibliography: p. 435-436. ', 'Michael Carrera.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Carrington, Richard. ', 'The mammals', 'mammals', 'Mammals; Juvenile literature; ', 'Time, inc.', '[1963]', 'QL706 .L5', '192 p. illus. (part col.) 28 cm.', 'by the editors of Life. Text by Richard Carrington. ', 'by the editors of Life. Text by Richard Carrington.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Carr, Archie Fairly ', 'The land and wildlife of Africa', 'land and wildlife of Africa', 'Natural history; ', 'Time, inc.', '[1964]', 'QH194 .C35', '200 p. illus. (1 fold.) facsims., maps, ports. 28 cm.', 'by Archie Carr and the editors of Life. Part of the illustrative matter is colored. Bibliography: p. 195. ', 'by Archie Carr and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Carroll, Lewis Guiliano, Edward. Tenniel, John ', 'The complete illustrated works of Lewis Carroll', 'complete illustrated works of Lewis Carroll', 'Alice (Fictitious character : Carroll); Fiction; ', 'Avenel Books', '1982', 'PR4611 .A4 1982', 'xxii, 868 p. : ill. ; 24 cm.', 'edited by Edward Guiliano ; illustrated by John Tenniel ... [et al.]. Bibliography: p. 865-868. ', 'edited by Edward Guiliano ; illustrated by John Tenniel ... [et al.].');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Carroll, Lewis ', 'Mathematical recreations of Lewis Carroll [pseud.]', 'Mathematical recreations of Lewis Carroll [pseud.]', 'Mathematical recreations; Logic, Symbolic and mathematical; ', 'Dover Publications', '[1958]', 'QA95 .D6', '2 v. illus. 21 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Carr, Archie Fairly ', 'The reptiles', 'reptiles', 'Reptiles; ', 'Time, inc.', '[1963]', 'QL644 .C3', '192 p. illus. 28 cm.', 'by Archie Carr and the editors of Life. ', 'by Archie Carr and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Carter, Jimmy ', 'An hour before daylight', 'hour before daylight', 'Childhood and youth; Presidents; Biography; Farmers; Biography; Biography; Social life and customs; Country life; History; Rural conditions; ', 'Simon & Schuster', 'c2001', 'E873 .C36 2001', '284 p. : ill. ; 25 cm.', 'Jimmy Carter. Includes index. ', 'Jimmy Carter.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Casson, Lionel ', 'Libraries in the ancient world', 'Libraries in the ancient world', 'Libraries; History; ', 'Yale University Press', 'c2001', 'Z722 .C37 2001', 'xii, 177 p. : ill., maps ; 22 cm.', 'Lionel Casson. Includes bibliographical references and index. ', 'Lionel Casson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Castro, Elizabeth. ', 'XML for the World Wide Web', 'XML for the World Wide Web', 'XML (Document markup language); World Wide Web; ', 'Peachpit Press', '2001', 'QA76.76.H94 C3697 2001', 'ix, 270 p. : ill. ; 23 cm.', 'by Elizabeth Castro. Includes index. ', 'by Elizabeth Castro.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Cervantes Saavedra, Miguel de Putnam, Samuel ', 'The ingenious gentleman Don Quixote de La Mancha', 'ingenious gentleman Don Quixote de La Mancha', '', 'Viking Press', '1949', 'PQ6329 .A2 1949', '2 v. (xxx, 1043 p.) 25 cm', 'Miguel de Cervantes Saavedra ; a new translation from the Spanish, with a critical text based upon the first editions of 1605 and 1615, and with variant readings, variorum notes, and an introduction by Samuel Putnam. Bibliography: v. 2, p. 1037-1043 ', 'Miguel de Cervantes Saavedra ; a new translation from the Spanish, with a critical text based upon the first editions of 1605 and 1615, and with variant readings, variorum notes, and an introduction by Samuel Putnam.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Charney, Maurice. ', 'How to read Shakespeare', 'How to read Shakespeare', 'Outlines, syllabi, etc; English drama; Study and teaching; Outlines, syllabi, etc; Study and teaching; ', 'McGraw-Hill', '[1971]', 'PR2987 .C47', 'x, 149 p. illus. 22 cm.', 'Bibliography: p. 146-149. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Charters, Samuel Barclay. ', 'The country blues', 'country blues', 'Country music; History and criticism; Blues (Music); History and criticism; ', 'Da Capo Press', '1975, c1959', 'ML3556.C475 C7 1975b', 'xix, 288 p., [8] leaves of plates : ill. ; 22 cm.', 'Samuel B. Charters, with a new introd. by the author. Reprint of the ed. published by Rinehart, New York. Includes index. ', 'Samuel B. Charters, with a new introd. by the author.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Charters, Ann ', 'The ragtime songbook', 'ragtime songbook', 'Popular music; Ragtime music; ', 'Oak Publications', '[1965]', 'M1630.18.C515 R3', '112 p. illus. 26 cm.', 'songs of the ragtime era by Scott Joplin ... and others. Compiled and edited, with historical notes concerning the songs and the times, by Ann Charters. Principally unacc., with chord symbols. "Introduction": p. 8-34. ', 'songs of the ragtime era by Scott Joplin ... and others. Compiled and edited, with historical notes concerning the songs and the times, by Ann Charters.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Chaucer, Geoffrey Dunn, Charles W. (Charles William) ', 'A Chaucer reader', 'Chaucer reader', 'Christian pilgrims and pilgrimages; Poetry; ', 'Harcourt, Brace and Co.', 'c1952', 'PR1867 .D8', 'xxxviii, 225 p. 20 cm.', 'edited by Charles W. Dunn. Includes bibliographical references (p. [xxxvii]-xxxviii). ', 'edited by Charles W. Dunn.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Chaucer, Geoffrey Darton, F. J. Harvey (Frederick Joseph Harvey) Kirk, Maria Louise ', 'The story of the Canterbury pilgrims', 'story of the Canterbury pilgrims', 'Christian pilgrims and pilgrimages; Fiction; ', 'Frederick A. Stokes Company', '[1914]', 'PR1872 .D3 1914', '5 p. l., 310 p. col. front., col. plates. 25 cm.', 'retold from Chaucer and others by F.J. Harvey Darton, illustrated by M.L. Kirk. Illustrated lining-papers. "Of the tales in this book, the following are taken from works not by Chaucer: Sir Gamelyn (author unknown); The story of Cambuscan Bold, pt. II (from Spenser), and part IV (from and eithteenth-century writer who attempted to complete this tale entirely); The chequer of the hoop, and Beryn (author unknown); and The destruction of Thebes (from Lydgate)." ', 'retold from Chaucer and others by F.J. Harvey Darton, illustrated by M.L. Kirk.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Choi, Wankyu. ', 'Beginning PHP4', 'Beginning PHP4', 'PHP (Computer program language); ', 'Wrox Press', 'c2000', 'QA76.73.P224 B44 2000', 'xi, 775 p. : ill. ; 24 cm.', 'Wankyu Choi ... [et al.]. Includes index. ', 'Wankyu Choi ... [et al.].');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Christiansen, Tom. Torkington, Nathan. ', 'Perl cookbook', 'Perl cookbook', 'Perl (Computer program language); ', 'OReilly', 'c1998', 'QA76.73.P22 C38 1998', 'xxxiv, 757 p. ; 24 cm.', 'Tom Christiansen and Nathan Torkington. Includes bibliographical references (p. xxvii-xxix) and index. ', 'Tom Christiansen and Nathan Torkington.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Clarke, Arthur Charles Time-Life Books ', 'Man and space', 'Man and space', 'Astronautics; Popular works; ', 'Time-Life Books', '[1968]', 'TL793 .C623 1968', '200 p. illus. (part col.), ports. 28 cm.', 'by Arthur C. Clarke and the editors of Time-Life Books. Bibliography: p. 196. ', 'by Arthur C. Clarke and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Cleveland, Donald B. Cleveland, Ana D. ', 'Introduction to indexing and abstracting', 'Introduction to indexing and abstracting', 'Indexing; Abstracting; ', 'Libraries Unlimited', '1983', 'Z695.9 .C592 1983', '209 p. : ill. ; 25 cm.', 'Donald B. Cleveland, Ana D. Cleveland. Includes index. Bibliography: p. 183-203. ', 'Donald B. Cleveland, Ana D. Cleveland.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Cohn, Lawrence ', 'Nothing but the blues', 'Nothing but the blues', 'Blues (Music); History and criticism; ', 'Abbeville Press', 'c1993', 'ML3521 .N68 1993', '432 p. : ill. ; 29 cm.', 'Lawrence Cohn... [et. al.]. Discography: p. 410-413. Includes bibliographical references (p. 414-416) and index. ', 'Lawrence Cohn... [et. al.].');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Comfort, Alex ', 'The Joy of sex', 'Joy of sex', 'Sex instruction; Sex customs; ', 'Crown', '[1972]', 'HQ9 .J68', '253 p. illus. 27 cm.', 'Edited by Alex Comfort. Illustrated by Charles Raymond and Christopher Foss. ', 'Edited by Alex Comfort. Illustrated by Charles Raymond and Christopher Foss.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Comfort, Alex ', 'More joy', 'More joy', 'Sex instruction; Sex customs; ', 'Crown Publishers', '[1974]', 'HQ31 .M695', '220 p. illus. 27 cm.', 'Edited by Alex Comfort. Illustrated by Charles Raymond and Christopher Foss. ', 'Edited by Alex Comfort. Illustrated by Charles Raymond and Christopher Foss.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Cooke, Donald Edwin Heugh, James. ', 'The romance of capitalism', 'romance of capitalism', 'Capitalism; Economic conditions; ', 'Winston', '[1958]', 'HC103 .C75', '145 p. illus. 25 cm.', 'how it grew from the early stock companies of 13th century Italy, how ruthless men exploited it, and how democratic government made it the hope of the world. ', 'how it grew from the early stock companies of 13th century Italy, how ruthless men exploited it, and how democratic government made it the hope of the world.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Cooper, David Edward. Lamarque, Peter. Sartwell, Crispin ', 'Aesthetics', 'Aesthetics', 'Aesthetics; ', 'Blackwell Publishers', '1997', 'BH39 .A3 1997', '276 p. ; 24 cm.', 'edited by David E. Cooper ; advisory editors, Peter Lamarque, Crispin Sartwell. Includes bibliographical references and index. ', 'edited by David E. Cooper ; advisory editors, Peter Lamarque, Crispin Sartwell.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Cooper, James Fenimore Nevins, Allan ', 'The Leatherstocking saga', 'Leatherstocking saga', '', 'Pantheon Books', '[1954]', 'PZ3.C786 Le', '833 p. illus., maps. 25 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Cooper, Kenneth H. ', 'The new aerobics', 'new aerobics', 'Aerobic exercises; Physical fitness; ', 'M. Evans; distributed in association with Lippincott, Philadelphia', '[1970]', 'RA781 .C62', '191 p. illus. 22 cm.', 'by Kenneth H. Cooper. Bibliography: p. 188-191. ', 'by Kenneth H. Cooper.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Copi, Irving M. ', 'Introduction to logic', 'Introduction to logic', 'Logic; ', 'Macmillan', 'c1978', 'BC108 .C69 1978', 'xiv, 590 p. : ill. ; 24 cm.', 'Irving M. Copi. Includes bibliographical references and index. ', 'Irving M. Copi.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Corbishley, Mike. ', 'The Middle Ages', 'Middle Ages', 'Civilization, Medieval; Juvenile literature; Civilization, Medieval; Middle Ages; ', 'Facts on File', 'c1990', 'CB351 .C59 1990', '96 p. : col. ill., col. maps ; 31 cm.', 'Mike Corbishley. "An Equinox book"--T.p. verso. Includes index. Includes bibliographical references (p. 92). ', 'Mike Corbishley.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Cordingly, David. ', 'Under the black flag', 'Under the black flag', 'Pirates; ', 'Harcourt Brace', '1997', 'G535 .C635 1997', 'xxi, 296 p. : ill., maps ; 24 cm.', 'David Cordingly. Originally published: New York : Random House, c1996. Includes bibliographical references (p. [279]-283) and index. ', 'David Cordingly.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Cornforth, Maurice Campbell. ', 'The theory of knowledge', 'theory of knowledge', 'Knowledge, Theory of; ', 'International Publishers', '[1955]', 'B809.8 .C68', '240 p. 22 cm.', 'Published in London in 1954 as v. 3 of the authors Dialectical Materialism. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Costales, Bryan. ', 'Sendmail', 'Sendmail', '', 'OReilly & Assoc.', '1993', '', '1 v.', 'Bryan Costales. ', 'Bryan Costales.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Coughlan, Robert Time-Life Books ', 'The world of Michelangelo, 1475-1564', 'world of Michelangelo, 1475-1564', 'History; ', 'Time, inc.', '[1966]', 'NB623.B9 C6', '202 p. illus. (part fold., part col.), coats of arms, geneal. tables, maps, plans, ports. (part col.) 31 cm.', 'by Robert Coughlan and the editors of Time-Life Books. Bibliography: p. 198-199. ', 'by Robert Coughlan and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Croce, Benedetto Ainslie, Douglas ', 'Aesthetic as science of expression & general linguistic', 'Aesthetic as science of expression & general linguistic', 'Aesthetics; Language and languages; Philosophy; Philosophy; ', 'Transaction Publishers', 'c1995', 'B3614.C73 E713 1995', 'xx, 503 p. ; 23 cm.', 'Benedetto Croce ; translated by Douglas Ainslie ; with a new introduction by John McCormick. Translation of: Estetica come scienza dellespressione e linguistica generale. Half title: Aesthetic. Originally published: 1909. With new introd. Includes bibliographical references (p. 475-489) and index. ', 'Benedetto Croce ; translated by Douglas Ainslie ; with a new introduction by John McCormick.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Dante Alighieri Brooks, Alfred Mansfield ', 'Dante, how to know him', 'Dante, how to know him', '', 'The Bobbs-Merrill Company', '[1916]', 'PQ4315.17 .B7', '6 p. l., 387 p. front. (port.) diagrs. 20 cm.', 'by Alfred M. Brooks ... with portrait. "Representative passages, for the most part translated outright, but in some instances paraphrased or condensed."--Pref. ', 'by Alfred M. Brooks ... with portrait.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Dante Alighieri Longfellow, Henry Wadsworth Whitman, Walt Charles E. Feinberg Collection of Walt Whitman (Library of Congress) ', 'The divine comedy of Dante Alighieri', 'divine comedy of Dante Alighieri', '', 'Ticknor and Fields', '1867', 'PQ4315 .L7 1867', '3 v. ; 25 cm.', 'translated by Henry Wadsworth Longfellow. ', 'translated by Henry Wadsworth Longfellow.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Date, C. J. ', 'An introduction to database systems', 'introduction to database systems', 'Database management; ', 'Addison-Wesley Pub. Co.', '1981-c1983', 'QA76.9.D3 D37 1981', '2 v. ; 25 cm.', 'C. J. Date. Includes bibliographies and index. ', 'C. J. Date.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Davies, John ', 'A history of Wales', 'history of Wales', 'History; ', 'Penguin Books', '1994', 'DA714 .D3913 1994', 'xiv, [1], 718 p. : ill., maps ; 20 cm.', 'John Davies. This translation originally published: London : Allen Lane, 1993. Translation of: Hanes Cymru. Includes bibliographical references (p. [xv]) and index. ', 'John Davies.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Davis, Philip J. Hersh, Reuben ', 'The mathematical experience', 'mathematical experience', 'Mathematics; Philosophy; Mathematics; History; Mathematics; Study and teaching; ', 'Birkhauser', '1981', 'QA8.4 .D37', 'xix, 440 p. : ill. ; 24 cm.', 'Philip J. Davis, Reuben Hersh ; with an introd. by Gian-Carlo Rota. Includes index. Bibliography: p. 417-434. ', 'Philip J. Davis, Reuben Hersh ; with an introd. by Gian-Carlo Rota.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('De Santillana, Giorgio ', 'The age of adventure', 'age of adventure', 'Philosophy, Renaissance; ', 'Houghton Mifflin', '1957 [c1956]', 'B775 .D4', '283 p. illus. 21 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Delft, Pieter van. Botermans, Jack ', 'Creative puzzles of the world', 'Creative puzzles of the world', 'Puzzles; ', 'H. N. Abrams', 'c1978', 'GV1493 .D4', '200 p. : ill. (some col.) ; 28 cm.', 'by Pieter van Delft and Jack Botermans ; introd. by Ir. W. L. van der Poel ; text by Chris Cooper and Charmian Murley ; special consultants, J. H. de Boer ... [et al.]. Bibliography: p. 200. ', 'by Pieter van Delft and Jack Botermans ; introd. by Ir. W. L. van der Poel ; text by Chris Cooper and Charmian Murley ; special consultants, J. H. de Boer ... [et al.].');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('DeMers, John Benghiat, Norma. ', 'The food of Jamaica', 'food of Jamaica', 'Cookery, Jamaican; ', 'Periplus Editions', 'c1998', 'TX716.J27 D46 1998', '132 p. : col. ill. ; 21 x 23 cm.', 'recipes and text by John DeMers ; food photography by Eduardo Fuss ; with additional contributions from Norma Benghiat. Includes index. ', 'recipes and text by John DeMers ; food photography by Eduardo Fuss ; with additional contributions from Norma Benghiat.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Dewey, John ', 'Art as experience', 'Art as experience', 'Aesthetics; Experience; ', 'Capricorn Books', '[1959, c1934]', 'N66 .D4 1959', 'vii, 355 p. 19 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Dewey, John Bentley, Arthur Fisher ', 'Knowing and the known', 'Knowing and the known', 'Knowledge, Theory of; ', 'Beacon Press', '1949', 'BD161 .D38', 'xiii, 334 p. 23 cm.', '[by] John Dewey and Arthur F. Bentley. ', '[by] John Dewey and Arthur F. Bentley.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Dewey, John ', 'Reconstruction in philosophy', 'Reconstruction in philosophy', 'Philosophy; ', 'Beacon Press', '[1957, c1948]', 'B945.D43 R4 1957', '224 p. 21 cm.', 'Enl. ed. with a new introd. by the author. ', 'Enl. ed. with a new introd. by the author.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Diamond, Michael R. Williams, Julie L. ', 'How to incorporate', 'How to incorporate', 'Incorporation; ', 'J. Wiley', 'c1996', 'KF1420 .D53 1996', 'ix, 310 p. : forms ; 29 cm.', 'Michael R. Diamond and Julie L. Williams. Includes index. ', 'Michael R. Diamond and Julie L. Williams.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Dickens, Charles ', 'Works', 'Works', '', '', '(1870?)', 'PZ3.D55 A2', '1 v. cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Dickinson, Emily ', 'Complete poems', 'Complete poems', '', 'Little, Brown', '[1960]', 'PS1541 .A1 1960', 'xiii, 770 p. 24 cm.', 'Edited by Thomas H. Johnson. ', 'Edited by Thomas H. Johnson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Dorland, W. A. Newman (William Alexander Newman) ', 'Dorlands illustrated medical dictionary', 'Dorlands illustrated medical dictionary', 'Medicine; Dictionaries; Dictionaries, Medical; Reference Books, Medical; ', 'W.B. Saunders Co.', '1957', 'R121 .D73', 'v. : ill. ; 27 cm.', 'Description based on: 26th ed. Latest issue consulted: 30th ed., copyrighted in 2003. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Dougherty, Dale. ', 'Sed & awk', 'Sed & awk', 'Utilities (Computer programs); ', 'OReilly', 'c1990', 'QA76.76.U84 D69 1990', 'xvii, 394 p. : ill. ; 23 cm.', 'Dale Dougherty. "UNIX power tools"--Cover. Includes bibliographical references and index. ', 'Dale Dougherty.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Downes, Olin Siegmeister, Elie ', 'A treasury of American song', 'treasury of American song', 'Folk-songs; Folk-songs; History and criticism. [from old catalog]; Ballads, American. [from old catalog]; ', 'Howell, Soskin & co.', '[c1940]', 'M1629.D748 T7', '351 p. 33 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Doyle, Arthur Conan ', 'The complete Sherlock Holmes', 'complete Sherlock Holmes', 'Holmes, Sherlock (Fictitious character); Fiction; Private investigators; Fiction; Detective and mystery stories, English; ', 'Doubleday', '[195-?]', 'PZ3.D772 Co 13', '2 v. (xviii, 1323 p.) 22 cm.', 'With a pref. by Christopher Morley. ', 'With a pref. by Christopher Morley.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Drabble, Margaret ', 'The Oxford companion to English literature', 'Oxford companion to English literature', 'English literature; Encyclopedias; English literature; Bio-bibliography; Encyclopedias; American literature; Encyclopedias; American literature; Bio-bibliography; Encyclopedias; ', 'Oxford University Press', '1985', 'PR19 .D73 1985', 'xii, 1155 p. ; 24 cm.', 'Rev. ed. of: The Oxford companion to English literature / compiled and edited by Paul Harvey. 4th ed. 1969. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Draper, Peter. [from old catalog] ', 'Guitar & flute duets', 'Guitar & flute duets', 'Flute and guitar music, Arranged. [from old catalog]; ', ': Consolidated Music Publishers', 'c1977', 'M1 .M8772 vol. 69', 'score (95 p.) and part ; 31 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Drew, W. S. (William Sydney) ', 'Singing, the art and the craft', 'Singing, the art and the craft', 'Singing; ', 'Oxford university press', '1937', 'MT820.D82 S61', 'x, 177 p. illus. (music) 23 cm.', 'by W. S. Drew. ', 'by W. S. Drew.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('DuBois, Paul ', 'MySQL', 'MySQL', 'SQL (Computer program language); ', 'New Riders', '1999', 'QA76.73.S67 D58 1999', 'xxix, 756 p. : ill. ; 23 cm.', 'Paul DuBois. Includes index. ', 'Paul DuBois.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Duce, Ivy Oneita. ', 'How a master works', 'How a master works', '', 'Sufism Reoriented, inc.', '1975', 'BL1175.M4 D78', 'xxiii, 768 p., [8] leaves of plates : ill. ; 25 cm.', 'by Ivy Oneita Duce. Bibliography: p. 767-768. ', 'by Ivy Oneita Duce.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Duffett-Smith, Peter. ', 'Practical astronomy with your calculator', 'Practical astronomy with your calculator', 'Astronomy; Problems, exercises, etc; Calculators; ', 'Cambridge University Press', '1981', 'QB62.5 .D83 1981', 'xvi, 188 p. : ill. ; 21 cm.', 'Peter Duffett-Smith. Includes index. ', 'Peter Duffett-Smith.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Eastman Kodak Company. [from old catalog] ', 'How to make good pictures', 'How to make good pictures', 'Photography; Handbooks, manuals, etc. [from old catalog]; ', '[n. d.]', '', 'TR146 .E135', 'v. illus. (part col.) 21 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('ECDL 2002 (2002 : Rome, Italy) Agosti, Maristella. Thanos, C. (Costantino) ', 'Research and advanced technology for digital libraries', 'Research and advanced technology for digital libraries', 'Digital libraries; Congresses; Digital libraries; Congresses; ', 'Springer', 'c2002', 'ZA4080 .E28 2002', 'xvi, 664 p. : ill. ; 24 cm.', 'Maristella Agosti, Costantino Thanos, eds. Includes bibliographical references and index. ', 'Maristella Agosti, Costantino Thanos, eds.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Eckstein, Robert. ', 'XML pocket reference', 'XML pocket reference', 'XML (Document markup language); World Wide Web; ', 'OReilly', 'c1999', 'QA76.76.H94 E25 1999', 'iii, 107 p. ; 18 cm.', 'Robert Eckstein. Includes index. ', 'Robert Eckstein.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Edwards, Betty ', 'Drawing on the right side of the brain', 'Drawing on the right side of the brain', 'Drawing; Technique; Visual perception; Cerebral dominance; ', 'J.P. Tarcher', 'c1989', 'NC730 .E34 1989', 'xiv, 254 p., [12] p. of plates : ill. (some col.) ; 24 cm.', 'Betty Edwards. Includes index. Includes bibliographical references (p. 247-250) ', 'Betty Edwards.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Edwards, Paul ', 'The Encyclopedia of philosophy', 'Encyclopedia of philosophy', 'Philosophy; Dictionaries; ', 'Macmillan', '[1967]', 'B41 .E5', '8 v. 29 cm.', 'Paul Edwards, editor in chief. Includes bibliographical references. ', 'Paul Edwards, editor in chief.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Edwards, Paul Pap, Arthur ', 'A modern introduction to philosophy', 'modern introduction to philosophy', 'Philosophy; Introductions; ', 'Free Press', '[1965]', 'BD21 .E4 1965', 'xvii, 797 p. 24 cm.', 'edited by Paul Edwards and Arthur Pap. Includes bibliographies. ', 'edited by Paul Edwards and Arthur Pap.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Eimerl, Sarel. DeVore, Irven ', 'The primates', 'primates', 'Primates; ', 'Time, inc.', '[1965]', 'QL737.P9 E5', '200 p. illus. (part col.) 28 cm.', 'by Sarel Eimerl and Irven DeVore, and the editors of Life. Bibliography: p. 193. ', 'by Sarel Eimerl and Irven DeVore, and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Eimerl, Sarel. Time-Life Books ', 'The world of Giotto, c. 1267-1337', 'world of Giotto, c. 1267-1337', '', 'Time, inc.', '[1967]', 'ND623.G6 E35', '199 p. illus. (part col.) 31 cm.', 'by Sarel Eimerl and the editors of Time-Life Books. Bibliography: p. 193-194. ', 'by Sarel Eimerl and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Einzig, Mitchell J. ', 'Baby & child emergency first aid handbook', 'Baby & child emergency first aid handbook', 'Pediatric emergencies; Handbooks, manuals, etc; First aid in illness and injury; Handbooks, manuals, etc; ', 'Meadowbrook Press', 'c1992', 'RJ370 .B3 1992', 'viii, 85 p. : ill. ; 29 cm.', 'edited by Mitchell J. Einzig. ', 'edited by Mitchell J. Einzig.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Emerson, Ralph Waldo ', 'The works of Ralph Waldo Emerson', 'works of Ralph Waldo Emerson', '', 'Tudor publishing company', '[193-]', 'PS1600 .F30a', '4 v. in 1. 24 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ende, Michael. Manheim, Ralph Quadflieg, Roswitha ', 'The neverending story', 'neverending story', 'Fantasy; ', 'Dutton Childrens Books', '1997', 'PZ7.E6964 Ne 1997b', '396 p. ; 22 cm.', 'by Michael Ende ; translated from the German by Ralph Manheim ; illustrated by Roswitha Quadflieg. ', 'by Michael Ende ; translated from the German by Ralph Manheim ; illustrated by Roswitha Quadflieg.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Engel, Peter ', 'Folding the universe', 'Folding the universe', 'Origami; ', 'Vintage Books', 'c1989', 'TT870 .E54 1989', 'ix, 323 p. : ill. (some col.) ; 28 cm.', 'Peter Engel. Includes index. Bibliography: p. 313-318. ', 'Peter Engel.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Engel, Leonard ', 'The sea', 'sea', 'Oceanography; Marine biology; Oceanography; Marine biology; ', 'Time inc.', '[c1963]', 'GC21 .E5 1963', '190 p. illus. (part col.) col. maps, ports. 28 cm.', 'by Leonard Engel and the editors of Life. Bibliography: p. 185. ', 'by Leonard Engel and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Engst, Adam C. ', 'Internet starter kit', 'Internet starter kit', 'Internet; Macintosh (Computer); ', 'Hayden Books', 'c1996', 'TK5105.875.I57 E5317 1996', 'xix, 858 p. ; 24 cm. + 1 computer disk (3 1/2 in.)', 'Adam C. Engst. Includes index. ', 'Adam C. Engst.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ensor, Pat. ', 'The cybrarians manual', 'cybrarians manual', 'Internet; Library information networks; ', 'American Library Association', '1997', 'Z674.75.I58 C93 1997', 'viii, 446 p. : ill., maps ; 25 cm.', 'Pat Ensor, editor. Includes bibliographical references and index. ', 'Pat Ensor, editor.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Evans, David ', 'Big road blues', 'Big road blues', 'Blues (Music); History and criticism; ', 'University of California Press', 'c1982', 'ML3521 .E9 1982', 'xi, 379 p. : ill. ; 27 cm.', 'David Evans. Includes music and index. Bibliography: p. [351]-364. ', 'David Evans.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Evans, Tom Evans, Mary Anne ', 'Guitars', 'Guitars', 'Guitar; ', 'Paddington Press : distributed by Grosset & Dunlap', 'c1977', 'ML1015.G9 E9', '479 p. : ill. ; 27 cm.', 'Tom and Mary Anne Evans. Includes index. Bibliography: p. 452-461. ', 'Tom and Mary Anne Evans.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Farb, Peter. ', 'Ecology', 'Ecology', 'Ecology; ', 'Time, inc.', '[c1963]', 'QH541 .F3', '192 p. illus. (part col.), col. maps. 28 cm.', 'by Peter Farb and the editors of Life. Bibliography: p. 183. ', 'by Peter Farb and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Farb, Peter. ', 'The forest', 'forest', 'Forest ecology; Forests and forestry; ', 'Time, inc.', '1961', 'QK938.F6 F34', '192 p. illus. 28 cm.', 'by Peter Farb and the editors of Life. Includes bibliography. ', 'by Peter Farb and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Farb, Peter. ', 'The insects', 'insects', 'Insects; ', 'Time, inc.', '[c1962]', 'QL467 .F359', '192 p. illus. 29 cm.', 'by Peter Farb and the editors of Life. ', 'by Peter Farb and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Farb, Peter. ', 'The land and wildlife of North America', 'land and wildlife of North America', 'Natural history; Wildlife conservation; ', 'Time Inc.', 'c1966', 'QH102 .F3 1966', '200 p. : ill. (some col.), maps ; 29 cm.', 'by Peter Farb and the editors of Life. "Time-Life Books." Originally published: 1964. Includes bibliographical references (p. 197) and index. ', 'by Peter Farb and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Feagin, Susan L. Maynard, Patrick ', 'Aesthetics', 'Aesthetics', 'Aesthetics; ', 'Oxford University Press', '1997', 'BH39 .A286 1997', 'vii, 418 p. " ill. ; 21 cm.', 'edited by Susan L. Feagin and Patrick Maynard. Includes bibliographical references (p. [390]-394) and index. ', 'edited by Susan L. Feagin and Patrick Maynard.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Feiler, Jesse. ', 'Making movies, photos, music & DVDs on your Mac', 'Making movies, photos, music & DVDs on your Mac', 'Motion pictures; Editing; Data processing; Photography; Digital techniques; Digital video; Editing; Data processing; Macintosh (Computer); ', 'McGraw-Hill/Osborne', 'c2002', 'TR899 .F45 2002', 'xxii, 409 p. : ill. ; 23 cm.', 'Jesse Feiler. Includes index. ', 'Jesse Feiler.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Feynman, Richard Phillips. Robbins, Jeffrey. ', 'The pleasure of finding things out', 'pleasure of finding things out', 'Science; ', 'Perseus Books', 'c1999', 'Q171 .F385 1999', 'xvi, 270 p. ; 22 cm.', 'by Richard P. Feynman ; edited by Jeffrey Robbins ; foreword by Freeman Dyson. Includes index. ', 'by Richard P. Feynman ; edited by Jeffrey Robbins ; foreword by Freeman Dyson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Fido, Martin. ', 'Shakespeare', 'Shakespeare', 'Dramatists, English; Biography; ', 'P. Bedrick Books', '1985, c1978', 'PR2894 .F44 1985', '144 p. : ill. (some col.) ; 30 cm.', 'Martin Fido. Includes index. ', 'Martin Fido.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Fitch, Jenny. Griffin, Daneen Nyimicz. ', 'The Fearrington House cookbook', 'Fearrington House cookbook', 'Cookery; Flower arrangement; Menus; ', 'Fitch Creations', 'c1987', 'TX714 .F58 1987b', 'xi, 269 p. : ill. ; 27 cm.', 'Jenny Fitch ; with illustrations by Daneen Nyimicz Griffin and others. Includes index. ', 'Jenny Fitch ; with illustrations by Daneen Nyimicz Griffin and others.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Flanagan, David. ', 'JavaScript', 'JavaScript', 'JavaScript (Computer program language); Web servers; Object-oriented programming (Computer science); ', 'OReilly', 'c1998', 'QA76.73.J39 F53 1998', 'xiv, 776 p. : ill. ; 24 cm.', 'David Flanagan. Includes index. ', 'David Flanagan.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Flanagan, David. ', 'JavaScript pocket reference', 'JavaScript pocket reference', 'JavaScript (Computer program language); ', 'OReilly', 'c1998', 'QA76.73.J39 F52 1998', 'v, 89 p. ; 18 cm.', 'David Flanagan. ', 'David Flanagan.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Flexner, James Thomas Time-Life Books ', 'The world of Winslow Homer, 1836-1910', 'world of Winslow Homer, 1836-1910', '', 'Time Inc.', '[1969, c1966]', 'ND237.H7 F4 1969', '190 p. illus. (part col.) 32 cm.', 'by James Thomas Flexner and the editors of Time-Life Books. Bibliography: p. 185. ', 'by James Thomas Flexner and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Foote, Timothy. Time-Life Books ', 'The world of Bruegel, c. 1525-1569', 'world of Bruegel, c. 1525-1569', '', 'Time-Life Books', '[1968]', 'ND673.B73 F6', '192 p. illus. (part col.), geneal. table, maps. 32 cm.', 'by Timothy Foote and the editors of Time-Life Books. Bibliography: p. 187. ', 'by Timothy Foote and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Foskett, A. C. (Antony Charles) ', 'The subject approach to information', 'subject approach to information', 'Subject cataloging; Indexing; ', 'C. Bingley', '1982', 'Z695 .F66 1982', 'xvii, 574 p. : ill. ; 23 cm.', 'A.C. Foskett. Includes bibliographical references and index. ', 'A.C. Foskett.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Foster, Stephen Collins ', 'A treasury of Stephen Foster', 'treasury of Stephen Foster', 'Songs (Medium voice) with piano. [from old catalog]; ', 'Random House', '[1946]', 'M1620.F753 H65', '222 p. col. illus., port. 31 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Frankenstein, Alfred Victor Time-Life Books ', 'The world of Copley, 1738-1815', 'world of Copley, 1738-1815', '', 'Time-Life Books', '[1970]', 'ND237.C7 F7', '192 p. illus. (part col.), ports. 32 cm.', 'by Alfred Frankenstein and the editors of Time-Life Books. Bibliography: p. 185. ', 'by Alfred Frankenstein and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Fremantle, Anne Jackson ', 'The age of belief', 'age of belief', 'Philosophy, Medieval; ', 'Books for Libraries Press', '[1970, c1954]', 'B720 .F7 1970', '218 p. 23 cm.', 'Selected, with introd. and interpretive commentary by Anne Fremantle. Bibliography: p. [214]-[215] ', 'Selected, with introd. and interpretive commentary by Anne Fremantle.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Frey, Skip. ', 'Complete book of dice games', 'Complete book of dice games', 'Dice games; ', 'Hart Pub. Co.', '[1975]', 'GV1303 .F73', '192 p. : ill. ; 18 cm.', 'Skip Frey. ', 'Skip Frey.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Gannett, Ruth Stiles. Gannett, Ruth Chrisman ', 'Three tales of my fathers dragon', 'Three tales of my fathers dragon', 'Dragons; Fiction; ', 'Random House', 'c1998', 'PZ7.G15 Th 1998', '241 p. : ill. ; 21 cm.', 'by Ruth Stiles Gannett ; illustrated by Ruth Chrisman Gannett. ', 'by Ruth Stiles Gannett ; illustrated by Ruth Chrisman Gannett.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Gies, Frances. Gies, Joseph. ', 'Cathedral, forge, and waterwheel', 'Cathedral, forge, and waterwheel', 'Technology; History; Inventions; History; Science, Medieval; ', 'HarperCollins Publishers', 'c1994', 'T17 .G54 1994', '357 p. : ill. ; 22 cm.', 'Frances & Joseph Gies. Includes bibliographical references (p. [329]-343) and index. ', 'Frances & Joseph Gies.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Gies, Joseph. Gies, Frances ', 'Life in a medieval castle', 'Life in a medieval castle', 'Castles; Courts and courtiers; Castles; Court and courtiers; History; Military history, Medieval; ', 'Harper & Row', '1979, c1974', 'GT3520 .G53 1979', 'xv, 272 p. : ill. ; 21 cm.', 'Joseph and Frances Gies. Includes index. Bibliography: p. 249-261. ', 'Joseph and Frances Gies.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ginzburg, Carlo. ', 'The cheese and the worms', 'cheese and the worms', 'Religious life and customs; Civilization; Peasantry; History; Heretics, Christian; Heresies, Christian; History; Church history; ', 'Johns Hopkins University Press', '1980', 'BR877.F74 G5613', 'xxvii, 177 p. : ill. ; 24 cm.', 'Carlo Ginzburg ; translated by John and Anne Tedeschi. Translation of Il formaggio e i vermi. Includes bibliographical references and index. ', 'Carlo Ginzburg ; translated by John and Anne Tedeschi.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Glover, Tony. [from old catalog] ', 'Blues harp', 'Blues harp', 'Mouth-organ; Methods; Self-instruction. [from old catalog]; ', 'Oak Publications', '[1965]', 'MT682.8 .G', '72 p. illus. 28 cm.', 'by Tony "Little Sun" Glover I. ', 'by Tony "Little Sun" Glover I.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Goldberg, Beverly. ', 'Overcoming high-tech anxiety', 'Overcoming high-tech anxiety', 'Employees; Effect of technological innovations on; Employees; Effect of automation on; Office practice; Automation; ', 'Jossey-Bass Publishers', 'c1999', 'HD6331 .G58 1999', 'xx, 187 p. ; 24 cm.', 'Beverly Goldberg. Includes bibliographical references (p. 167-176) and index. ', 'Beverly Goldberg.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Goldstein, Joyce Esersky. ', 'Kitchen conversations', 'Kitchen conversations', 'Cookery; ', 'Wm. Morrow', 'c1996', 'TX714 .G649 1996', 'xxxvii, 378 p. : ill. ; 26 cm.', 'Joyce Goldstein. Includes index. ', 'Joyce Goldstein.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Goldwater, Robert John Treves, Marco ', 'Artists on art, from the XIV to the XX century. 100 illustrations', 'Artists on art, from the XIV to the XX century. 100 illustrations', 'Art; Artists; ', 'Pantheon books', '[1945]', 'N79 .G57', '1 p.l., v-xv, 497, [1] p. illus. (incl. ports.) 24 cm.', 'Compiled and edited by Robert Goldwater and Marco Treves. "We have translated into English for the first time nearly one-half of the artists writing quoted, and have reworked other selections for this book."--Foreword. "Sources": p. 480-487. ', 'Compiled and edited by Robert Goldwater and Marco Treves.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Good, Phyllis Pellman Stoltzfus, Louise Central Market (Lancaster, Pa.) ', 'The Central Market cookbook', 'Central Market cookbook', 'Cookery; ', 'Good Books', 'c1989', 'TX714 .G65 1989', '224 p., [12] p. of plates : ill. ; 26 cm.', 'Phyllis Pellman Good and Louise Stoltzfus. Includes bibliographical references. ', 'Phyllis Pellman Good and Louise Stoltzfus.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Gordon, J. Arthur. Irregardless (Restaurant) ', 'The Irregardless cooks', 'Irregardless cooks', 'Cookery; Cookery, International; ', 'Ten Speed Press', 'c1983', 'TX715 .G6624 1983', 'xviii, 112 p. : ill. ; 21 x 27 cm.', 'J. Arthur Gordon ; designed and illustrated by Linda Funk. Includes index. ', 'J. Arthur Gordon ; designed and illustrated by Linda Funk.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Gosney, Michael Odam, John. Benson, Jim. ', 'The gray book', 'gray book', 'Desktop publishing; Graphic arts; Data processing; ', 'Ventana Press', 'c1990', 'Z253.53 .G67 1990', 'ix, 263 p. : ill. ; 24 cm.', 'Michael Gosney, John Odam, Jim Benson. Includes index. ', 'Michael Gosney, John Odam, Jim Benson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Graham-Campbell, James. ', 'The Viking world', 'Viking world', 'Vikings; Northmen; ', 'Ticknor & Fields', '1980', 'DL65 .G63 1980', '220 p. : ill. (some col.) ; 29 cm.', 'James Graham-Campbell ; foreword by David M. Wilson. Includes index. Bibliography: p. 214. ', 'James Graham-Campbell ; foreword by David M. Wilson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Grant, Michael ', 'Dawn of the Middle Ages, A.D. 476-814', 'Dawn of the Middle Ages, A.D. 476-814', 'Middle Ages; History; ', 'McGraw-Hill', '1981', 'D117 .G7', ' p. cm.', 'Michael Grant. Includes index. Bibliography: p. ', 'Michael Grant.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Gray, Henry Goss, Charles Mayo ', 'Anatomy of the human body', 'Anatomy of the human body', 'Human anatomy; ', 'Lea & Febiger', '1948', 'QM23 .G7 1948', '1478 p. illus. (part col.) port. 27 cm.', 'First published in London in 1858 under title: Anatomy, descriptive and surgical. Includes bibliographies. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Green Note Music Publications ', 'The art of ragtime guitar', 'art of ragtime guitar', 'Guitar; Methods; Self-instruction; Guitar music (Ragtime); ', 'Green Note Music Publications', 'c1974', 'MT588.G75575 A8', '95 p. : ill ; 28 cm. + 1 sound disc (analog, 33 1/3 rpm ; 8 in.)', 'by the staff of Green Note Music Publications. Discography: p. 93. ', 'by the staff of Green Note Music Publications.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Greene, Theodore Meyer ', 'The arts and the art of criticism', 'arts and the art of criticism', 'Art; Philosophy; Aesthetics; Criticism; Music; Philosophy and aesthetics; ', 'Princeton University Press', '1940', 'N66 .G74', 'xxx, 690 p., 1 l., incl. illus., plates. front. fold. diagr. 24 cm.', 'by Theodore Meyer Greene. Includes music. ', 'by Theodore Meyer Greene.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Grossman, Stefan, [from old catalog] Calt, Stephan, [from old catalog] Grossman, Hal, [from old catalog] ', 'Country blues songbook', 'Country blues songbook', 'Blues (Songs, etc.); Negro songs. [from old catalog]; ', 'Oak Publications', '[c1973]', 'M1630.18.G759 C7', '208 p. illus. 28 cm.', 'by Stefan Grossman, Stephen Calt and Hal Grossman. Melodies with chord symbols and guitar chord diagrams. Discography: p. 207-208. ', 'by Stefan Grossman, Stephen Calt and Hal Grossman.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Grossman, Stefan. ', 'Delta blues guitar', 'Delta blues guitar', 'Guitar; Methods (Blues); Blues (Music); ', 'Oak Publications', '[1969]', 'MT582.G755 D4', '136 p. illus. 28 cm.', '"A detailed analysis and transcription [in standard notation and tablature] of the personal guitar styles of the legendary greats of the Mississippi Delta region." ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Grossman, Stefan. ', 'Ragtime blues', 'Ragtime blues', 'Guitar; Methods (Ragtime); Guitar; Methods (Blues); Ragtime music; Instruction and study; Blues (Music); Instruction and study; ', 'Oak Publications', 'c1984', 'MT582.G755 R3 1984', '111 p. of music : ill. ; 31 cm. + 1 sound disc (analog, 33 1/3 rpm, mono. ; 8 in.)', 'by Stefan Grossman. Rev. ed. of Ragtime blues guitarists. 1970. Accompanying disc is a soundsheet. Discography: p. 109-111. ', 'by Stefan Grossman.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Grossman, Stefan. ', 'Texas blues', 'Texas blues', 'Guitar; Methods (Blues); Blues (Music); Instruction and study; ', 'Oak Publications', 'c1984', 'MT582.G755 T5 1984', '144 p. of music : ill. ; 31 cm. + 1 sound disc (analog, 33 1/3 rpm, stereo. ; 8 in.)', 'by Stefan Grossman. Accompanying disc is a soundsheet. Discography: p. 142-143. ', 'by Stefan Grossman.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Gross, Gay Merrill. ', 'Origami', 'Origami', 'Origami; ', 'Friedman/Fairfax Publishers', 'c1994', 'TT870 .G79 1994', '72 p. : col. ill. ; 26 cm.', 'Gay Merrill Gross ; principal photographer, Ellen Silverman ; original diagrams by Gay Merrill Gross ; illustrations by Anne L. Meskey. Includes index. ', 'Gay Merrill Gross ; principal photographer, Ellen Silverman ; original diagrams by Gay Merrill Gross ; illustrations by Anne L. Meskey.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Grout, Donald Jay. Palisca, Claude V. ', 'A history of western music', 'history of western music', 'Music; History and criticism; ', 'Norton', 'c1980', 'ML160 .G87 1980', 'xii, 849 p. : ill. ; 24 cm.', 'Donald Jay Grout. Includes index. Bibliography: p. 761-799. ', 'Donald Jay Grout.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Grove, George Colles, Henry Cope ', 'Groves Dictionary of music and musicians', 'Groves Dictionary of music and musicians', 'Music; Dictionaries; Music; Bio-bibliography; ', 'The Macmillan company', '1927-28', 'ML100 .G886', '5 v. fronts. (v. 2-5 col.) illus. (incl. music) XCII pl. (part col., incl. ports., facsims.; music) diagrs. 24 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Gullan-Whur, Margaret. ', 'Within reason', 'Within reason', 'Philosophers; Biography; ', 'St. Martins Press', '2000', 'B3997 .G84 2000', 'xviii, 398 p. : 1 map ; 25 cm.', 'Margaret Gullan-Whur. Originally published: London : J. Cape, 1998. Includes bibliographical references (p. 368-381) and index. ', 'Margaret Gullan-Whur.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Gundavaram, Shishir. ', 'CGI programming on the World Wide Web', 'CGI programming on the World Wide Web', 'CGI (Computer network protocol); Perl (Computer program language); Web servers; Computer programs; ', 'OReilly & Associates', '1996', 'TK5105.565 .G85 1996', 'xiv, 433 p. : ill. ; 23 cm.', 'Shishir Gundavaram. Includes index. ', 'Shishir Gundavaram.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hadingham, Evan. ', 'Circles and standing stones', 'Circles and standing stones', 'Megalithic monuments; Antiquities; ', 'Walker', '1975', 'GN805 .H33 1975', '240 p. : ill. ; 26 cm.', 'Evan Hadingham. Includes index. Bibliography: p. [212]-222. ', 'Evan Hadingham.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hafen, Le Roy Reuben Carter, Harvey Lewis ', 'Mountain men and fur traders of the Far West', 'Mountain men and fur traders of the Far West', 'History; Biography; Trappers; Biography; Fur traders; Biography; Biography; Fur trade; History; ', 'University of Nebraska Press', '1982', 'F592 .M742 1982', 'xviii, 401 p. : ill. ; 20 cm.', 'edited by LeRoy R. Hafen ; selected, with an introduction, by Harvey L. Carter. "A Bison book." Reprinted from: The Mountain men and the fur trade of the Far West. Glendale, Calif. : A.H. Clark, 1965-1972. Includes bibliographical references and index. ', 'edited by LeRoy R. Hafen ; selected, with an introduction, by Harvey L. Carter.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hale, William Harlan Time-Life Books ', 'The world of Rodin, 1840-1917', 'world of Rodin, 1840-1917', '', 'Time-Life Books', '[c1969]', 'NB553.R7 H27', '192 p. illus. (part col.), ports. 31 cm.', 'by William Harlan Hale and the editors of Time-Life Books. With photos. by Lee Boltin and Dmitri Kessel. Bibliography: p. 187. ', 'by William Harlan Hale and the editors of Time-Life Books. With photos. by Lee Boltin and Dmitri Kessel.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hall, Trevor H. Ellison, Charles O. ', 'Sherlock Holmes and his creator', 'Sherlock Holmes and his creator', 'Characters; Sherlock Holmes; Holmes, Sherlock (Fictitious character); Detectives in literature; ', 'St. Martins Press', '1978, c1977', 'PR4624 .H255 1978', 'xi, 155 p. ; 23 cm.', 'Trevor H. Hall ; with contributions by Charles O. Ellison. Includes bibliographical references and indexes. ', 'Trevor H. Hall ; with contributions by Charles O. Ellison.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hampshire, Stuart ', 'The age of reason', 'age of reason', 'Philosophy, Modern; ', 'Books for Libraries Press', '[1970, c1956]', 'B801 .H3 1970', '186 p. 23 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Harold, Elliotte Rusty. Means, W. Scott. ', 'XML in a nutshell', 'XML in a nutshell', 'XML (Document markup language); ', 'OReilly', '2001', 'QA76.76.H94 H36 2001', 'xvi, 480 p. : ill. ; 23 cm.', 'Elliotte Rusty Harold & W. Scott Means. Includes index. ', 'Elliotte Rusty Harold & W. Scott Means.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Harrison, Tinsley Randolph ', 'Principles of internal medicine', 'Principles of internal medicine', 'Medicine; Practice; ', 'Blakiston Division, McGraw-Hill', '[1962]', 'RC46 .H32 1962', 'xxiii, 1947 p. illus. 26 cm.', 'Editors: T.R. Harrison [and others] Includes bibliography. ', 'Editors: T.R. Harrison [and others]');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hart, James David ', 'The Oxford companion to American literature', 'Oxford companion to American literature', 'American literature; Dictionaries, indexes, etc; American literature; Bio-bibliography; ', 'Oxford University Press', '1948', 'PS21 .H3 1948', 'viii, 890 p.  24 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hart, James David ', 'The Oxford companion to American literature', 'Oxford companion to American literature', 'American literature; Dictionaries; American literature; Bio-bibliography; Dictionaries; ', 'Oxford University Press', '1965', 'PS21 .H3 1965', 'ix, 991 p. 25 cm.', '[by] James D. Hart. ', '[by] James D. Hart.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hawkins, Gerald S. ', 'Stonehenge decoded', 'Stonehenge decoded', 'Megalithic monuments; Prehistoric peoples; Antiquities; Astronomy, Ancient; ', 'Doubleday', '1965', 'DA142 .H3', 'viii, 202 p. illus., maps, plates. 24 cm.', '[by] Gerald S. Hawkins in collaboration with John B. White. Includes bibliographies. ', '[by] Gerald S. Hawkins in collaboration with John B. White.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hazan, Marcella. ', 'Marcellas Italian kitchen', 'Marcellas Italian kitchen', 'Cookery, Italian; ', 'Knopf', '1986', 'TX723 .H3424 1986', 'xii, 349 p., [12] p. of plates : col. ill. ; 24 cm.', 'by Marcella Hazan. Includes index. ', 'by Marcella Hazan.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Heidegger, Martin ', 'Basic writings', 'Basic writings', 'Philosophy; ', 'Harper & Row', 'c1977', 'B3279.H47 E5 1977', 'xvi, 397 p. ; 21 cm.', 'Martin Heidegger ; edited, with general introd. and introductions to each selection by David Farrell Krell. Bibliography: p. 395-397. ', 'Martin Heidegger ; edited, with general introd. and introductions to each selection by David Farrell Krell.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Heilbron, J. L. ', 'The sun in the Church', 'sun in the Church', 'Astronomical observatories; Astronomy, Renaissance; Religion and science; History; History; ', 'Harvard University Press', '1999', 'QB29 .H33 1999', 'ix, 366 p. : ill. (some col.) ; 26 cm.', 'J.L. Heilbron. Includes bibliographical references (p. 305-328) and index. ', 'J.L. Heilbron.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hemingway, Ernest ', 'For whom the bell tolls / By Ernest Hemingway', 'For whom the bell tolls / By Ernest Hemingway', 'History; Fiction; Americans; Fiction; ', 'Charles Scribners', '[1968?], c1940', 'PS3515.E37 F6 1968', '471 p. 22 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hemp, Michael Kenneth ', 'Cannery Row', 'Cannery Row', 'History; Homes and haunts; ', 'History Co.', 'c1986', 'F869.M7 H35 1986', '128 p. : ill. ; 26 cm.', 'by Michael Kenneth Hemp. "Photography from the Pat Hathaway Historical Photo Collection"--Cover. Page 128 blank. Includes index. Bibliography: p. 125. ', 'by Michael Kenneth Hemp.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Henry, O. ', 'The complete works of O. Henry [pseud.]', 'complete works of O. Henry [pseud.]', '', 'Garden City Publishing Company inc.', '1937', 'PZ3.P835 Co', 'xv, 1653 p., 1 l. 22 cm.', 'Foreword by William Lyon Phelps. "First de luxe edition." ', 'Foreword by William Lyon Phelps.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Herbert, Brian. Anderson, Kevin J. Herbert, Frank. ', 'Dune', 'Dune', 'Dune (Imaginary place); Fiction; ', 'Bantam Books', '2001', 'PS3558.E617 D865 2001', '496 p. : maps ; 25 cm.', 'Brian Herbert and Kevin J. Anderson. Based on the Dune universe created by Frank Herbert. ', 'Brian Herbert and Kevin J. Anderson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hibbert, Christopher Newsweek, inc ', 'Tower of London', 'Tower of London', 'Buildings, structures, etc; Fortification; History; Prisons; History; History; ', 'Newsweek', '[1971]', 'DA687.T7 H5', '172 p. illus. (part col.), facsims., plan, ports. 30 cm.', 'by Christopher Hibbert and the editors of the Newsweek Book Division. Bibliography: p. 169. ', 'by Christopher Hibbert and the editors of the Newsweek Book Division.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Himsworth, Harold ', 'Scientific knowledge & philosophic thought', 'Scientific knowledge & philosophic thought', 'Science; Philosophy; Science; Methodology; Knowledge, Theory of; Problem solving; ', 'Johns Hopkins University Press', 'c1986', 'Q175 .H48 1986', 'viii, 113 p. ; 22 cm.', 'Harold Himsworth. Includes index. Bibliography: p. [101]-105. ', 'Harold Himsworth.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hirsh, Diana. Time-Life Books ', 'The world of Turner, 1775-1851', 'world of Turner, 1775-1851', '', 'Time-Life Books', '[1969]', 'ND497.T8 H64', '192 p. illus. (part col.) 32 cm.', 'by Diana Hirsh and the editors of Time-Life Books. Bibliography: p. 187. ', 'by Diana Hirsh and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hitch, Allen S. ', 'Conservation and you', 'Conservation and you', 'Natural resources; ', 'Van Nostrand', '[c1964]', 'S930 .H5', 'xiv, 126 p. illus. 20 cm.', 'by Allen S. Hitch & Marian Sorenson. Bibliography: p. 117-119.  "Material sources": p. 120. ', 'by Allen S. Hitch & Marian Sorenson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hoffer, Eric. ', 'The true believer', 'true believer', '', 'Time Inc.', 'c1963', '', '188 p.', 'Eric Hoffer with a new introduction by Sidney Hook. ', 'Eric Hoffer with a new introduction by Sidney Hook.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hofstadter, Douglas R. ', 'Godel, Escher, Bach', 'Godel, Escher, Bach', 'Metamathematics; Symmetry; Artificial intelligence; ', 'Vintage Books', '1980, c1979', 'QA9.8 .H63 1980', 'xxi, 777 p. : ill. ; 24 cm.', 'Douglas R. Hofstadter.  Reprint of the ed. published by Basic Books, New York. Includes index. Bibliography: p. 746-756. ', 'Douglas R. Hofstadter. ');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hofstadter, Douglas R. ', 'Metamagical themas', 'Metamagical themas', 'Artificial intelligence; Intellect; Science; Philosophy; Metamathematics; Self (Philosophy); Amusements; ', 'Basic Books', 'c1985', 'Q335 .H63 1985', 'xxviii, 852 p. : ill. ; 24 cm.', 'Douglas R. Hofstadter. Includes index. Bibliography: p. 802-819. ', 'Douglas R. Hofstadter.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hollister, C. Warren (Charles Warren) ', 'Medieval Europe', 'Medieval Europe', 'History; Middle Ages; ', 'Wiley', '[1968]', 'D117 .H6 1968', 'xvi, 362 p. illus., maps. 22 cm.', '[by] C. Warren Hollister. Includes bibliographies. ', '[by] C. Warren Hollister.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Holman, G. Ken ', 'Definitive XSL-F0', 'Definitive XSL-F0', 'XSL (Document markup language); Electronic publishing; ', 'Prentice Hall Professional Technical Reference', '2003', 'QA76.76.H94 H62 2003', 'xxiv, 455 p. : ill. ; 24 cm.', 'G. Ken Holman. Includes index. ', 'G. Ken Holman.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Holmes, Urban Tigner ', 'Daily living in the twelfth century, based on the observations of Alexander Neckam in London and Paris', 'Daily living in the twelfth century, based on the observations of Alexander Neckam in London and Paris', 'Social life and customs; Social life and customs; Social life and customs; Cities and towns, Medieval; ', 'University of Wisconsin Press', '1952', 'GT120 .H64 1952', '337 p. illus. 22 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Holzschlag, Molly E. ', 'Special edition using HTML and XHTML', 'Special edition using HTML and XHTML', 'HTML (Document markup language); XHTML (Document markup language); ', 'Que', 'c2002', 'QA76.76.H94 H6532 2002', 'xi, 700 p. : ill. ; 24 cm.', 'Molly E.  Holzschlag. Includes index. ', 'Molly E.  Holzschlag.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Honda, Isao ', 'How to make origami', 'How to make origami', 'Paper work; ', 'McDowell, Obolensky', '[1959]', 'TT870 .H6 1959', '37 p. col. illus. (part fold. mounted) 26 cm.', '16 sheets of col. paper in pocket. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Honda, Isao ', 'The world of origami', 'world of origami', 'Origami. [from old catalog]; ', '[published] in collaboration with Japan Publications Trading Co. [by] Blandford P.', '1965', 'TT870 .H653 1965a', 'xii, 13-264 p. illus. (some col.) 31 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Honderich, Ted. ', 'The Oxford companion to philosophy', 'Oxford companion to philosophy', 'Philosophy; History; Philosophers; ', 'Oxford University Press', '1995', 'B51 .O94 1995', 'xviii, 1009 p. : ill. ; 24 cm.', 'edited by Ted Honderich. Includes bibliographical references and index. ', 'edited by Ted Honderich.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hooper, A. (Alfred) ', 'The river mathematics', 'river mathematics', 'Mathematics; ', 'H. Holt and company', '[1945]', 'QA39 .H67', '4 p.l., 401 p. illus. (incl. maps) fold. pl., diagrs. (1 fold.) 22 cm.', 'At head of title: A. Hooper, M.A. "First printing." ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hoople, Ross Earle Piper, Raymond Frank Tolley, William Pearson ', 'Preface to philosophy', 'Preface to philosophy', 'Philosophy; ', 'The Macmillan company', '1946', 'BD31 .H66', 'xii, 513 p. 22 cm.', '[by] Ross Earle Hoople, Raymond Frank Piper [and] William Pearson Tolley. ', '[by] Ross Earle Hoople, Raymond Frank Piper [and] William Pearson Tolley.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Howell, Francis Clark. ', 'Early man', 'Early man', 'Human evolution; Prehistoric peoples; ', 'Time, inc.', '[1965]', 'QH368 .H638', '200 p. illus., maps, ports. 28 cm.', 'by F. Clark Howell and the editors of Life. Part of the illustrative matter is colored. Bibliography: p. 193. ', 'by F. Clark Howell and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hudson, W. D. (William Donald) ', 'Reason and right', 'Reason and right', 'Ethics; History; ', 'Freeman, Cooper', '[1970]', 'BJ604.P7 H8 1970b', 'xii, 205 p. 24 cm.', '[by] W. D. Hudson. Includes bibliographical references. ', '[by] W. D. Hudson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Huizinga, Johan ', 'The waning of the Middle Ages', 'waning of the Middle Ages', 'Civilization; Civilization; Civilization, Medieval; ', 'St. Martins Press', '[1985], c1924', 'DC33.2 .H83 1985', 'viii, 328 p., [14] p. of plates : ill. ; 23 cm.', 'by J. Huizinga. Reprint. Originally published: London : E. Arnold, 1924. Translation of: Herfsttij der Middeleeuwen. Includes index. Bibliography: p. 309-318. ', 'by J. Huizinga.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hulsker, Jan. ', 'The complete Van Gogh', 'complete Van Gogh', 'Catalogues raisonnes; ', 'H.N. Abrams', '1980, c1977', 'ND653.G7 H7913 1980', '498 p. : ill. (some col.) ; 36 cm.', 'Jan Hulsker. Translation of Van Gogh en zijn weg. Includes index. Bibliography: p. 489-490. ', 'Jan Hulsker.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hunt, Craig. ', 'TCP/IP network administration', 'TCP/IP network administration', 'TCP/IP (Computer network protocol); ', 'OReilly & Associates', 'c1992', 'TK5105.55 .H86 1992', 'xxii, 471 p. : ill. ; 23 cm.', 'by Craig Hunt. "Help for UNIX System administrators"--Cover. Includes index. ', 'by Craig Hunt.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Hutchins, Robert Maynard Encyclopaedia Britannica University of Chicago ', 'Great books of the Western World', 'Great books of the Western World', 'Literature; Collections; Literature; Indexes; ', 'W. Benton', '[1952]', 'AC1 .G7', '54 v. illus., maps. 25 cm.', '[Robert Maynard Hutchins, editor in chief. General t.p. in vol. 1 only: each vol. has special t.p. "Limited to 500 numbered copies signed by the editor." L.C. copy neither numbered nor signed. Includes bibliographies. ', '[Robert Maynard Hutchins, editor in chief.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ifrah, Georges. ', 'From one to zero', 'From one to zero', 'Numeration; History; Numerals; History; ', 'Viking', '1985', 'QA141.2 .I3613 1985', 'xvi, 503 p. : ill. ; 25 cm.', 'Georges Ifrah ; translated by Lowell Bair. Translation of: Histoire universelle des chiffres. c1981. Bibliography: p. 499-502. ', 'Georges Ifrah ; translated by Lowell Bair.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ingersoll-Rand Company ', 'The story of the Hoover Dam', 'story of the Hoover Dam', '', 'Ingersoll-Rand', '1932-', 'TC425 .C', '  v. illus. 30 cm.', 'Reprinted from Compressed Air Magazine (1931- and Western Construction News and Highway Builder of Nov. 10, 1932) ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Jacobus, Lee A. ', 'Aesthetics and the arts', 'Aesthetics and the arts', 'Form (Aesthetics); Addresses, essays, lectures; Art; Philosophy; Addresses, essays, lectures; ', 'McGraw-Hill', '[1968]', 'N7430 .J3', 'xii, 315 p. 23 cm.', '[by] Lee A. Jacobus. Bibliography: p. 311-315. ', '[by] Lee A. Jacobus.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Jacoby, Oswald Crawford, John R. ', 'The backgammon book', 'backgammon book', 'Backgammon; ', 'Viking Press', '[1970]', 'GV1469.B2 J3 1970', '224 p. illus. (part col.) 27 cm.', '[by] Oswald Jacoby [and] John R. Crawford. ', '[by] Oswald Jacoby [and] John R. Crawford.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Jaffrey, Madhur. ', 'Flavors of India', 'Flavors of India', 'Cookery, Indic; ', 'C. Southern Books', 'c1995', 'TX724.5.I5 J34 1995', '320 p. : col. ill., col. map ; 26 cm.', 'Madhur Jaffrey. Includes index. ', 'Madhur Jaffrey.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Jahoda, Gerald ', 'Information storage and retrieval systems for individual researchers', 'Information storage and retrieval systems for individual researchers', 'Indexing; ', 'Wiley-Interscience', '[1970]', 'Z695.9 .J35', 'xiii, 135 p. illus. 23 cm.', 'Includes bibliographies. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('James, William Castell, Alburey ', 'Essays in pragmatism', 'Essays in pragmatism', 'Philosophy; ', 'Hafner Pub. Co.', '1948', 'B945.J23 E67', 'xvi, 176 p. 21 cm.', 'Edited with an introd. by Alburey Castell. "Selected bibliography": p. xvi. ', 'Edited with an introd. by Alburey Castell.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('James, Jamie. ', 'The music of the spheres', 'music of the spheres', 'Music and science; Music; Philosophy and aesthetics; Science; Philosophy; Harmony of the spheres; ', 'Grove Press', 'c1993', 'ML3800 .J22 1993', 'xv, 262 p. : ill. ; 25 cm.', 'Jamie James. Includes bibliographical references (p. 243-247) and index. ', 'Jamie James.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Jamison, Cheryl Alters. Jamison, Bill. ', 'Smoke & spice', 'Smoke & spice', 'Barbecue cookery; Smoked foods; Spices; ', 'Harvard Common Press', 'c2003', 'TX840.B3 .J36 2003', 'xiv, 482 p. : ill. (some col.) ; 24 cm.', 'Cheryl and Bill Jamison. Includes index. ', 'Cheryl and Bill Jamison.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Jayne, Caroline Furness ', 'String figures and how to make them', 'String figures and how to make them', 'String figures; ', 'Dover Publications', '[1962]', 'GN455.S9 J4 1962', '407 p. illus. 22 cm.', 'With an ethnological introd. by Alfred C. Haddon. "An unabridged republication of the work first published ... in 1906 under the former title: String figures." ', 'With an ethnological introd. by Alfred C. Haddon.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Johnson, Robert Ainslie, Scott. Whitehill, David. ', 'Robert Johnson', 'Robert Johnson', 'Blues (Music); ', 'H. Leonard Pub. Corp.', 'c1992', 'M1630.18.J6835 A37 1992', '1 score (126 p.) : ill. ; 31 cm.', 'transcribed by Scott Ainslie and Dave Whitehill. Blues for voice and guitar (in tablature and staff notation with chord symbols). Song lyrics also printed as texts preceding each song. ', 'transcribed by Scott Ainslie and Dave Whitehill.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Jones, W. T. (William Thomas) ', 'A history of Western philosophy', 'history of Western philosophy', 'Philosophy; History; ', 'Harcourt, Brace & World', '[1969]', 'B72 .J652 1969', '4 v. 23 cm.', '[by] W. T. Jones. Includes bibliographical references. ', '[by] W. T. Jones.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Joyce, James Herman Finkelstein Collection (Library of Congress) ', 'Ulysses', 'Ulysses', 'City and town life; Fiction; Fiction; Married people; Fiction; Jewish men; Fiction; Artists; Fiction; ', 'Random house', '1934]', 'PR6019.O9 U4 1934', 'xvii, 767, [1] p. illus. (music) 21 1/2 cm.', '[by] James Joyce. Title on two leaves. "First American edition." LC copy has dust jacket. Source: Gift of Herman Finkelstein, Dec. 30, 1980. ', '[by] James Joyce.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kabir, Mohammed J. ', 'Red Hat Linux 6 server', 'Red Hat Linux 6 server', 'Operating systems (Computers); ', 'IDG Books', '1999', 'QA76.76.O63 K314 1999', 'xxviii, 785 p.: ill. ; 23 cm. +1computer laser optical disc (4 3/4 in.)', 'Mohammed J. Kabir. ', 'Mohammed J. Kabir.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kaelin, Eugene Francis ', 'An existentialist aesthetic', 'existentialist aesthetic', 'Aesthetics; ', 'University of Wisconsin Press', '1962', 'B2430.S34 K3', 'xv, 471 p. 25 cm.', 'Bibliography: p. 453-461. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kafka, Franz ', 'The castle', 'castle', '', 'Knopf', '1954', 'PZ3.K11 Cas8', 'xvi, 481 p. 20 cm.', 'translated from the German by Willa and Edwin Muir, with additional materials translated by Eithne Wilkins and Ernst Kaiser. With an homage by Thomas Mann. ', 'translated from the German by Willa and Edwin Muir, with additional materials translated by Eithne Wilkins and Ernst Kaiser. With an homage by Thomas Mann.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kafka, Barbara. James Beard Foundation ', 'The James Beard celebration cookbook', 'James Beard celebration cookbook', 'Cookery; ', 'W. Morrow', 'c1990', 'TX714 .J36 1990', '415 p. : ill. ; 27 cm.', '[by the James Beard Foundation ; edited by Barbara Kafka]. Includes index. ', '[by the James Beard Foundation ; edited by Barbara Kafka].');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kafka, Barbara. ', 'Roasting', 'Roasting', 'Roasting (Cookery); ', 'Morrow', 'c1995', 'TX690 .K34 1995', '452 p. : col. ill. ; 26 cm.', 'Barbara Kafka ; photographs by Maria Robledo. Includes index. ', 'Barbara Kafka ; photographs by Maria Robledo.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kalter, Suzy. ', 'The complete book of M*A*S*H', 'complete book of M*A*S*H', '', 'H.N. Abrams', '[1984]', 'PN1992.77.M2854 K3 1984', '233 p. : ill. (some col.) ; 31 cm.', 'by Suzy Kalter ; introduction by Larry Gelbart. ', 'by Suzy Kalter ; introduction by Larry Gelbart.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kathrens, Ginger ', 'Cloud, wild stallion of the Rockies', 'Cloud, wild stallion of the Rockies', 'Cloud (Horse); Juvenile literature; Wild horses; Biography; Juvenile literature; Juvenile literature; Human-animal relationships; Juvenile literature; Cloud (Horse); Wild horses; Human-animal relationships; ', 'BowTie Press', 'c2001', 'SF360.3.R53 K38 2001', '160 p. : col. ill. ; 29 cm.', 'by Ginger Kathrens. Includes bibliographical references (p. 159-160). ', 'by Ginger Kathrens.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kaufmann, Walter Arnold. Baird, Forrest E. ', 'Philosophic classics', 'Philosophic classics', 'Philosophy; ', 'Prentice Hall', 'c1994', 'B21 .P39 1994', '4 v. : ill. ; 24 cm.', '[compiled by] Walter Kaufmann, Forrest E. Baird, editor. Includes bibliographical references. ', '[compiled by] Walter Kaufmann, Forrest E. Baird, editor.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kawai, Toyoaki. Elliott, Thomas I. Kenny, Don. ', 'Colorful origami', 'Colorful origami', '', 'Barnes & Noble Books', '[c1983]', 'TT870 .K2913 1983', 'iv, 135 p. : ill. (some col.) ; 15 cm.', 'by Toyoaki Kawai ; translated by Thomas I. Elliott ; edited by Don Kenny. Translation of: Origami. ', 'by Toyoaki Kawai ; translated by Thomas I. Elliott ; edited by Don Kenny.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kay, Michael R. ', 'XSLT programmers reference', 'XSLT programmers reference', 'Programming languages (Electronic computers); XSLT (Computer program language); ', 'Wrox Press', 'c2001', 'QA76.7.K395 2001', 'xxxiii, 939 p. : ill. ; 23 cm.', 'Michael Kay. Includes index. ', 'Michael Kay.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kemp, D. Alasdair. ', 'The nature of knowledge', 'nature of knowledge', 'Knowledge, Theory of; Library science; Philosophy; ', 'C. Bingley', '1976', 'BD161 .K45 1976', '199 p. : ill. ; 23 cm.', 'by D A Kemp. Includes index. Bibliography: p. 175-189. ', 'by D A Kemp.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kendall, Paul Murray ', 'The Yorkist age', 'Yorkist age', 'Social life and customs; History; ', 'W.W. Norton & Co.', '[1962]', 'DA245 .K4', '524p. illus. 21cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kenna, L. A. ', 'Understanding mathematics, with visual aids', 'Understanding mathematics, with visual aids', 'Mathematics; Study and teaching; Audio-visual aids; ', 'Littlefield, Adams', '1962', 'QA11 .K48', '174 p. illus. 21 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kernighan, Brian W. Ritchie, Dennis M. ', 'The C programming language', 'C programming language', 'C (Computer program language); ', 'Prentice Hall', 'c1988', 'QA76.73.C15 K47 1988', 'xii, 272 p. ; 25 cm.', 'Brian W. Kernighan, Dennis M. Ritchie. Includes index. ', 'Brian W. Kernighan, Dennis M. Ritchie.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kilgour, Frederick G. Becker, Patricia A. Dodson, Ann T. Yoakam, Lois L. ', 'Collected papers of Frederick G. Kilgour', 'Collected papers of Frederick G. Kilgour', 'Library science; Library information networks; Libraries; Automation; Medical libraries; Science; ', 'OCLC Online Computer Library Center', 'c1984', 'Z674 .K46 1984', '2 v. : ill. ; 28 cm.', 'compiled by Patricia A. Becker, Ann T. Dodson ; edited by Lois L. Yoakam. Papers chiefly in English; one paper each in French, German, and Italian. Includes bibliographies and indexes. ', 'compiled by Patricia A. Becker, Ann T. Dodson ; edited by Lois L. Yoakam.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kimball, Christopher. ', 'The cooks bible', 'cooks bible', 'Cookery; ', 'Little, Brown and Company', 'c1996', 'TX651 .K56 1996', 'xv, 443 p. : ill. ; 26 cm.', 'Christopher Kimball. Includes index. ', 'Christopher Kimball.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kimball, Christopher. ', 'The dessert bible', 'dessert bible', 'Desserts; ', 'Little, Brown', 'c2000', 'TX773 .K24 2000', 'xiv, 399 p. : ill. ; 29 cm.', 'Christopher Kimball. Includes index. ', 'Christopher Kimball.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kimball, Christopher. ', 'The yellow farmhouse cookbook', 'yellow farmhouse cookbook', 'Cookery, American; Low budget cookery; ', 'Little, Brown', 'c1998', 'TX715 .K449 1998', 'xix, 410 p. : ill. ; 26 cm.', 'Christopher Kimball. Includes index. ', 'Christopher Kimball.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('King, Jerry P. ', 'The art of mathematics', 'art of mathematics', 'Mathematics; ', 'Plenum Press', 'c1992', 'QA36 .K47 1992', 'vi, 313 p. : ill. ; 22 cm.', 'Jerry P. King. Includes bibliographical references (p. 297-303) and index. ', 'Jerry P. King.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kline, Morris ', 'Mathematics for the nonmathematician', 'Mathematics for the nonmathematician', 'Mathematics; ', 'Dover', '1985, c1967', 'QA37.2 .K6 1985', 'xiii, 641 p. : ill. ; 22 cm.', 'Morris Kline. Reprint. Originally published: Mathematics for liberal arts. Reading, Mass. : Addison-Wesley, c1967. (Addison-Wesley series in introductory mathematics) Includes bibliographies and index. ', 'Morris Kline.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Koestler, Arthur ', 'The ghost in the machine', 'ghost in the machine', 'Genetic psychology; Human evolution; ', 'Hutchinson', '1967', 'BF701 .K64 1967', 'xiv, 384 p. diagrs. 22 cm.', 'Bibliography: p. [359]-365. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Koestler, Arthur ', 'The sleepwalkers', 'sleepwalkers', 'Astronomy; History; Religion and science; History; ', 'Hutchinson', '[1959]', 'BL245 .K63', '624 p. illus. 22 cm.', 'With an introd. by Herbert Butterfield. Includes bibliography. ', 'With an introd. by Herbert Butterfield.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Koning, Hans. Time-Life Books ', 'The world of Vermeer, 1632-1675', 'world of Vermeer, 1632-1675', 'Painters; Biography; ', 'Time, inc.', '[1967]', 'ND653.V5 K6', '192 p. illus., col. plates. 31 cm.', 'by Hans Koningsberger and the editors of Time-Life Books. Bibliography: p. 187. ', 'by Hans Koningsberger and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Korner, Stephan ', 'The philosophy of mathematics', 'philosophy of mathematics', 'Mathematics; Philosophy; ', 'Hutchinson University Library', '[1960]', 'QA9 .K677', '198 p. 19 cm.', 'Includes bibliography. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kramer, Greg. ', 'SimCity 4', 'SimCity 4', '', 'Prima Games', 'c2002', '', 'vi, 358 p. : ill. ; 24 cm.', 'Greg Kramer. Includes index. ', 'Greg Kramer.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kuhns, Richard Francis ', 'Structures of experience', 'Structures of experience', 'Philosophy; Literature; Philosophy; Experience; ', 'Basic Books', '[c1970]', 'B66 .K84', 'xii, 274 p. 22 cm.', '[by] Richard Kuhns. Includes bibliographical references. ', '[by] Richard Kuhns.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Kuhn, Thomas S. ', 'The structure of scientific revolutions', 'structure of scientific revolutions', 'Science; Philosophy; Science; History; ', 'University of Chicago Press', '1970]', 'Q175 .K95 1970', 'xii, 210 p. 24 cm.', 'by Thomas S. Kuhn. Includes bibliographical references. ', 'by Thomas S. Kuhn.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lamb, Charles Lamb, Mary Rhead, Louis ', 'Tales from Shakespeare', 'Tales from Shakespeare', 'Adaptations; ', 'Harper & Brothers', '[1918]', 'PR2877 .L3 1918', 'xiv, [1], 366, [1] p. incl front. (3 port.) illus., plates. 23 cm.', 'by Charles & Mary Lamb; with numerous illustrations by Louis Rhead. Title within ornamental border. ', 'by Charles & Mary Lamb; with numerous illustrations by Louis Rhead.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lang, Robert J. ', 'The complete book of origami', 'complete book of origami', 'Origami; ', 'Dover', '1988', 'TT870 .L26 1988', 'v, 154 p. : ill. ; 31 cm.', 'Robert J. Lang ; photography by Robin Macey. Includes bibliographical references. ', 'Robert J. Lang ; photography by Robin Macey.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Langsam, Yedidyah Augenstein, Moshe Tenenbaum, Aaron M. ', 'Data structures for personal computers', 'Data structures for personal computers', 'Data structures (Computer science); Microcomputers; Programming; BASIC (Computer program language); ', 'Prentice-Hall', 'c1985', 'QA76.9.D35 L36 1985', 'xvi, 560 p. : ill. ; 25 cm.', 'Yedidyah Langsam, Moshe J. Augenstein, Aaron M. Tenenbaum. Includes index. Bibliography: p. 548-550. ', 'Yedidyah Langsam, Moshe J. Augenstein, Aaron M. Tenenbaum.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lapp, Ralph Eugene ', 'Matter', 'Matter', 'Matter; ', 'Time, inc.', '[1963]', 'QC171 .L33', '200 p. illus. (part col.) ports., facsims. 28 cm.', 'by Ralph E. Lapp and the editors of Life. Bibliography: p. 196. ', 'by Ralph E. Lapp and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Large, Laura Antoinette Stevers ', 'Little people who became great', 'Little people who became great', 'Children; Biography; Biography; Juvenile literature; ', 'W. A. Wilde company', '[c1920]', 'CT107 .L4', '135 p., front., plates, ports. 20 cm.', 'by Laura Antoinette Large ; illlustrated by photos. ', 'by Laura Antoinette Large ; illlustrated by photos.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lavender, David Sievert ', 'The American heritage history of the great West', 'American heritage history of the great West', 'History; ', 'American Heritage Pub. Co.; book trade distribution by Simon and Schuster', '1965', 'F591 .L387', '416 p. illus. (part col.) facsims., maps (part fold. col.) ports. (part col.) 29 cm.', 'by the editors of American heritage. Editor in charge: Alvin M. Josephy, Jr. Author: David Lavender. Pictorial commentary: Ralph K. Andrist. ', 'by the editors of American heritage. Editor in charge: Alvin M. Josephy, Jr. Author: David Lavender. Pictorial commentary: Ralph K. Andrist.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('La Place, Viana. ', 'Verdura', 'Verdura', 'Cookery (Vegetables); Cookery, Italian; ', 'Morrow', 'c1991', 'TX801 .L3 1991', '388 p. : ill. ; 27 cm.', 'Viana La Place ; illustrations by Ann Field. Includes bibliographical references (p. [371]-372) and index. ', 'Viana La Place ; illustrations by Ann Field.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lee, Robert E. (Robert Earl) ', 'Blackbeard the pirate', 'Blackbeard the pirate', 'Pirates; ', 'J. F. Blair', '[1974]', 'F257.T422 L43', 'viii, 264 p. : port. ; 24 cm.', 'by Robert E. Lee. Includes index. Bibliography: p. [245]-255. ', 'by Robert E. Lee.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lemay, Laura. ', 'Teach yourself more Web publishing with HTML in a week', 'Teach yourself more Web publishing with HTML in a week', 'HTML (Document markup language); World Wide Web; Internet; Electronic publishing; Programmed instruction; Hypertext systems; ', 'Sams.net Publishing', 'c1995', 'QA76.76.H94 L45 1995', 'xxi, 451 p. : ill. ; 23 cm.', 'Laura Lemay. Includes bibliographical references (p. 420-427) and index. ', 'Laura Lemay.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lennon, John McCartney, Paul, [from old catalog] ', 'Lennon & McCartney for recorder : [with lyrics and guitar acc. chords]', 'Lennon & McCartney for recorder : [with lyrics and guitar acc. chords]', 'Recorder music, Arranged. [from old catalog]; Recorder and guitar music, Arranged. [from old catalog]; ', '', 'c1975', 'M63.L47 L5', '80 p. : port. ; 28 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Leonard, Jonathan Norton Time-Life Books ', 'The world of Gainsborough, 1727-1788', 'world of Gainsborough, 1727-1788', '', 'Time-Life Books', '[1969]', 'ND497.G L4', '192 p. illus. (part col.) 31 cm.', 'By Jonathan Norton Leonard and the editors of Time-Life Books. Bibliography: p. 187. ', 'By Jonathan Norton Leonard and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Leopold, A. Starker (Aldo Starker) ', 'The desert', 'desert', 'Deserts; Desert ecology; Desert resources development; ', 'Time', '1961', 'GB611 .L4', '192 p. illus. (part col., part fold.) map. 28 cm.', 'by A. Starker Leopold and the editors of Life. ', 'by A. Starker Leopold and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Leopold, Luna Bergere Davis, Kenneth Sydney ', 'Water', 'Water', 'Water; ', 'Time, inc.', '[1966]', 'GB671 .L4', '200 p. illus. (part col.) col. maps. 28 cm.', 'by Luna B. Leopold, Kenneth S. Davis, and the editors of Life. Bibliography: p. 196. ', 'by Luna B. Leopold, Kenneth S. Davis, and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lerner, Frederick Andrew ', 'The story of libraries', 'story of libraries', 'Libraries; History; ', 'Continuum', '1998', 'Z721 .L565 1998', '246 p. : ill. ; 24 cm.', 'Fred Lerner. Includes bibliographical references (p. [220]-236) and index. ', 'Fred Lerner.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('LeShan, Lawrence L. Margenau, Henry ', 'Einsteins space and Van Goghs sky', 'Einsteins space and Van Goghs sky', 'Science; Philosophy; Science; Methodology; Reality; Reductionism; ', 'Macmillan', 'c1982', 'Q175 .L444 1982', 'xiv, 268 p. : ill. ; 24 cm.', 'by Lawrence LeShan and Henry Margenau. Includes bibliographical references and index. ', 'by Lawrence LeShan and Henry Margenau.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lessac, Arthur. ', 'The use and training of the human voice', 'use and training of the human voice', 'Voice culture; ', 'DBS Publications', '[1967]', 'PN4162 .L46 1967', 'xviii, 297 p. illus. 26 cm.', 'Pref. by Irene Dailey. Illustrated by John Wilson. ', 'Pref. by Irene Dailey. Illustrated by John Wilson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lestz, Gerald S. [from old catalog] ', 'Historic heart of Lancaster', 'Historic heart of Lancaster', 'Historic houses, etc. [from old catalog]; ', 'J. Baers Sons', '[1963, c1962]', 'F159.L2 L5 1963', '56 p. illus. 22 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lever, Evelyne. ', 'Marie-Antoinette', 'Marie-Antoinette', 'Queens; Biography; History; ', 'Fayard', 'c1991', 'DC137.1 .L48 1991', '736 p. ; 23 cm.', 'Evelyne Lever. Includes bibliographical references (p. [699]-717) and index. ', 'Evelyne Lever.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lewis, Meriwether Clark, William De Voto, Bernard Augustine ', 'The journals of Lewis and Clark', 'journals of Lewis and Clark', 'Description and travel; Description and travel; Description and travel; History; ', 'Franklin Library', '1982', 'F592.4  1982', 'lix, 556 p., [8] leaves of plates : ill. ; 24 cm.', 'edited by Bernard De Voto ; with illustrations by artists of the Old West. Reprint. Originally published: Boston : Houghton Mifflin, 1953. "Notes from the editors" (22 p.) laid in. Includes bibliographical references and index. ', 'edited by Bernard De Voto ; with illustrations by artists of the Old West.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lewis, C. S. (Clive Staples) Baynes, Pauline ', 'The magicians nephew', 'magicians nephew', 'Fantasy; ', 'Collier Books', '1986, c1955', 'PZ7.L58474 Mag 1986', '168 p. : ill. ; 21 cm.', 'C.S. Lewis ; illustrations by Pauline Baynes. ', 'C.S. Lewis ; illustrations by Pauline Baynes.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lewisohn, Ludwig ', 'The story of American literature', 'story of American literature', 'American literature; History and criticism; ', 'The Modern Library', '[1939]', 'PS88 .L45 1930', '6 p. l., vii-xxxii, 652 p. 21 cm.', 'by Ludwig Lewisohn. "First Modern library giant edition." ', 'by Ludwig Lewisohn.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lewis, C. S. (Clive Staples) ', 'Out of the silent planet', 'Out of the silent planet', 'Life on other planets; Fiction; ', 'Scribner Paperback Fiction', '1996', 'PR6023.E926 O54 1996', '160 p. ; 18 cm.', 'C.S. Lewis. ', 'C.S. Lewis.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lewis, C. S. (Clive Staples) ', 'Perelandra', 'Perelandra', 'Good and evil; Fiction; ', 'Scribner Classics', '1996', 'PR6023.E926 P47 1996b', '190 p. ; 24 cm.', 'C.S. Lewis. The second of a trilogy, the title of the first being Out of the silent planet and that of the third That hideous strength. ', 'C.S. Lewis.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lewis, C. S. (Clive Staples) ', 'That hideous strength', 'That hideous strength', '', 'Scribner Classics', '1996', 'PR6023.E926 T47 1996b', '380 p. ; 25 cm.', 'C.S. Lewis. ', 'C.S. Lewis.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ley, Willy ', 'The poles', 'poles', '', 'Time, inc.', '[1962]', 'G590 .L4', '192 p. illus. 28 cm.', 'by Willy Ley and the editors of Life. ', 'by Willy Ley and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lidell, Lucy. ', 'The book of massage', 'book of massage', 'Massage; Mind and body; Holistic medicine; ', 'Simon and Schuster', 'c1984', 'RA780.5 .L53 1984', '192 p. : col. ill. ; 24 cm.', 'by Lucinda Lidell ... [et al.] ; photography by Fausto Dorelli ; foreword by Clare Maxwell-Hudson. "A Fireside book." Includes index. Bibliography: p. 190. ', 'by Lucinda Lidell ... [et al.] ; photography by Fausto Dorelli ; foreword by Clare Maxwell-Hudson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lockie, Andrew. ', 'Natural Health encyclopedia of homeopathy', 'Natural Health encyclopedia of homeopathy', 'Homeopathy; Encyclopedias; Homeopathy; Popular works; ', 'D. Kindersley Pub.', 'c2000', 'RX41 .L625 2000', '336 p. : ill. ; 29 cm.', 'Andrew Lockie. Includes bibliographical references (p. 314-315) and index. ', 'Andrew Lockie.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Longaberger Company ', 'Fresh from the pantry', 'Fresh from the pantry', 'Cookery, American; ', 'Longaberger Co.', '2001', 'TX715 .L8218 2001', '192 p. : col. ill. ; 26 cm.', 'Longaberger. ', 'Longaberger.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Longfellow, Henry Wadsworth ', 'The complete poetical works of Henry Wadsworth Longfellow', 'complete poetical works of Henry Wadsworth Longfellow', '', 'Houghton, Mifflin and company', '1902', 'PS2250.F O2', 'xxv, 879 p. illus.  21 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Lovell, Douglas. ', 'XSL formatting objects', 'XSL formatting objects', '', 'Sams', 'c2003', '', 'ix, 426 p. : ill. ; 24 cm.', 'Douglas Lovell. ', 'Douglas Lovell.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Loyn, H. R. (Henry Royston) ', 'The Middle Ages', 'Middle Ages', 'Middle Ages; Dictionaries; Civilization, Medieval; Dictionaries; ', 'Thames and Hudson', '1989', 'CB351 .M565 1989', '352 p. : ill. ; 26 cm.', 'general editor, H.R. Loyn. Includes bibliographical references. ', 'general editor, H.R. Loyn.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ludwig, Emil Lindsay, Mary H. ', 'The Nile', 'Nile', 'Description and travel; ', 'Garden City Pub. Co.', '[1947, c1937.]', 'DT115 .L82 1947', 'xvi, 619 p. plates, maps. 24 cm.', 'Tr. by Mary H. Lindsay. ', 'Tr. by Mary H. Lindsay.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Macarthur, John Robertson. ', 'Biblical literature and its backgrounds', 'Biblical literature and its backgrounds', 'Introductions; Bible as literature; ', 'D. Appleton-Century Company', '[c1936]', 'BS475 .M29', 'xix, 528 p. incl. front., illus., maps (1 double) plan, facsims. 18 cm.', 'by John Robertson Macarthur. Being a gathering together from far and near of divers and sundry facts and opinions which may enable those familiar with that masterpiece of the English language, the King James Bible, to read it more understandingly and with a greater appreciation of its literary felicities and perfections. Map on front lining-paper. Bibliography: p. 521-522. ', 'by John Robertson Macarthur. Being a gathering together from far and near of divers and sundry facts and opinions which may enable those familiar with that masterpiece of the English language, the King James Bible, to read it more understandingly and with a greater appreciation of its literary felicities and perfections.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Macaulay, David. ', 'Castle', 'Castle', 'Castles; Juvenile literature; Fortification; Juvenile literature; Castles; Fortification; ', 'Houghton Mifflin', '1977', 'UG405 .M18', '74 p. : ill. ; 32 cm.', 'David Macaulay. ', 'David Macaulay.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Macaulay, David. ', 'Cathedral: the story of its construction', 'Cathedral: the story of its construction', 'Cathedrals; Architecture, Gothic; Cathedrals; Architecture, Gothic; ', 'Houghton Mifflin', '1973', 'NA4830 .M32', '77 p. illus. 31 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Madison, Deborah. ', 'The savory way', 'savory way', 'Cookery; ', 'Bantam Books', 'c1990', 'TX714 .M335 1990', 'xx, 444 p. : ill. ; 27 cm.', 'by Deborah Madison ; illustrations by Patricia Curtan. "June 1990"--T.p. verso. Includes bibliographical references (p. 433-434) and index. ', 'by Deborah Madison ; illustrations by Patricia Curtan.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Madison, Deborah. ', 'Vegetarian cooking for everyone', 'Vegetarian cooking for everyone', 'Vegetarian cookery; ', 'Broadway Books', 'c1997', 'TX837 .M23618 1997', 'x, 742 p., [24] p. of plates : ill. (some col.) ; 26 cm.', 'Deborah Madison ; [photographs by Laurie Smith]. Includes index. ', 'Deborah Madison ; [photographs by Laurie Smith].');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Magill, Frank Northen ', 'Masterpieces of world literature in digest form', 'Masterpieces of world literature in digest form', 'Literature; Stories, plots, etc; ', 'Harper', '[1952-69]', 'PN44 .M3 1952', '4 v. 24 cm.', 'First appeared in the authors Masterplots, 1949-68. Series is updated by the Masterplots annual. "Cumulative author index: series one, two, three, and four": v. 4, p. i-xxii at end. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Magill, Frank Northen Kohler, Dayton ', 'Masterplots', 'Masterplots', 'Literature; Stories, plots, etc; ', 'Salem Press', '[1954-68]', 'PN44 .M3 1954a', '8 v. 24 cm.', 'Edited by Frank N. Magill. Story editor, Dayton Kohler. 1st-[4th] ser. Subtitle varies: [v. 1-2] 510 plots in story form from the worlds fine literature. [v. 3-4] 500 plots in story form from the worlds fine literature. [v. 5-8] Five hundred plot-stories and essay-reviews from the worlds fine literature. ', 'Edited by Frank N. Magill. Story editor, Dayton Kohler. 1st-[4th] ser.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Mangano, Sal. ', 'XSLT cookbook', 'XSLT cookbook', 'XSLT (Computer program language); XML (Document markup language); ', 'OReilly', '[2002], c2003', 'QA76.73.X58 M36 2003', 'xiv, 654 p. : ill. ; 24 cm.', 'Sal Mangano. "Solutions and examples for XML and XSLT developers"--Cover. Includes bibliographical references and index. ', 'Sal Mangano.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Manning, Harvey. ', 'Backpacking, one step at a time', 'Backpacking, one step at a time', 'Backpacking; Backpacking; Equipment and supplies; ', 'Vintage Books', 'c1980', 'GV199.6 .M36 1980', 'xvi, 414 p. : ill. ; 20 cm.', 'by Harvey Manning ; foreword by Jim Whittaker ; cartoons by Bob Cram ; photos. by Keith Gunnar. Includes index. ', 'by Harvey Manning ; foreword by Jim Whittaker ; cartoons by Bob Cram ; photos. by Keith Gunnar.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('May, Herbert Gordon Metzger, Bruce Manning, [from old catalog] ', 'The Holy Bible', 'Holy Bible', '', 'Oxford University Press', '1962', 'BS191 .A1 1962.N4 (Rare Bk Coll.)', 'xxiv, 1544 p. col. maps. 23 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('McClure, Susan Rodale Food Center ', 'Preserving summers bounty', 'Preserving summers bounty', 'Vegetables; Preservation; Fruit; Preservation; Cookery (Vegetables); Cookery (Fruit); ', 'Rodale Press', 'c1995', 'TX612.V4 P74 1995', 'xi, 372 p. : ill. ; 25 cm.', 'edited by Susan McClure and the staff of the Rodale Food Center. Includes bibliographical references (p. 361) and index. ', 'edited by Susan McClure and the staff of the Rodale Food Center.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('McColley, Grant ', 'Literature and science', 'Literature and science', 'English literature; American literature; Literature and science; ', 'Packard and Company', '1940', 'PR1111.S3 M25', '2 p. l., iii-xii, 528 p. 23 cm.', 'selected and edited by Grant McColley ... "Biographical notes": p. 519-528. ', 'selected and edited by Grant McColley ...');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('McCrum, Robert. Cran, William. MacNeil, Robert ', 'The story of English', 'story of English', 'English language; History; ', 'Viking', '1986', 'PE1075 .M58 1986', '384 p. : ill. (some col.) ; 26 cm.', 'Robert McCrum, William Cran, Robert MacNeil. "Elisabeth Sifton books." Includes index. Bibliography: p. 353-368. ', 'Robert McCrum, William Cran, Robert MacNeil.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('McDowell, Tremaine ', 'The romantic triumph', 'romantic triumph', 'American literature; ', 'Macmillan', '1949', 'PS504 .A62 vol. 2 1949', 'xv, 955 p. 22 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('McEwan, Ian. Browne, Anthony ', 'The daydreamer', 'daydreamer', 'Imagination; Fiction; Family life; Fiction; ', 'HarperCollins', 'c1994', 'PZ7.M4784546 Day 1994', '192 p. : ill. ; 23 cm.', 'Ian McEwan ; illustrated by Anthony Browne. ', 'Ian McEwan ; illustrated by Anthony Browne.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('McInerny, Ralph M. ', 'Celt and pepper', 'Celt and pepper', 'Knight, Roger (Fictitious character); Fiction; Knight, Philip (Fictitious character); Fiction; Private investigators; Fiction; Fiction; Fiction; College teachers; Fiction; ', 'St. Martins Minotaur', '2002', 'PS3563.A31166 C45 2002', '210 p. ; 22 cm.', 'Ralph McInerny. ', 'Ralph McInerny.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('McSpadden, Lynn. [from old catalog] ', 'Four & twenty songs for the mountain dulcimer', 'Four & twenty songs for the mountain dulcimer', 'Dulcimer; Instruction and study. [from old catalog]; ', 'Dulcimer Shoppe', '1970]', 'M1629 .F7', '44 p. cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Mednis, Edmar ', 'How to play good opening moves', 'How to play good opening moves', 'Chess; Openings; ', 'D. McKay', 'c1982', 'GV1450 .M42 1982', 'x, 128 p. : ill. ; 21 cm.', 'Edmar Mednis. ', 'Edmar Mednis.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Menzel, Donald Howard ', 'A field guide to the stars and planets', 'field guide to the stars and planets', 'Astronomy; Observers manuals; ', 'Houghton Mifflin', '1964', 'QB64 .M4', 'xiv, 397 p. illus., charts. 20 cm.', 'by Donald H. Menzel. With photos., and with sky maps and other illus. by Ching Sung Yu . ', 'by Donald H. Menzel. With photos., and with sky maps and other illus. by Ching Sung Yu .');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Merriam-Webster, Inc ', 'Merriam-Websters encyclopedia of literature', 'Merriam-Websters encyclopedia of literature', 'Literature; Dictionaries; ', 'Merriam-Webster', 'c1995', 'PN41 .M42 1995', 'xii, 1236 p. : ill. ; 27 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Michelangelo Buonarroti Goldscheider, Ludwig ', 'Michelangelo', 'Michelangelo', '', 'Phaidon', '1975', 'N6923.B9 G57 1975', '264, [1] p., [11] p. of plates : ill. (some col.) ; 32 cm.', '[text] by Ludwig Goldscheider. Distributed by Praeger, New York. Includes index. Bibliography: p. 25-26. ', '[text] by Ludwig Goldscheider.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Mich, Daniel Danforth. Eberman, Edwin. ', 'The technique of the picture story', 'technique of the picture story', 'Journalism, Pictorial; ', 'McGraw-Hill Book Company, inc.', '1945', 'PN4784.P5 M5', '239 p. illus. (incl. ports.) 26 cm.', 'by Daniel D. Mich, executive editor [and] Edwin Eberman, art director, Look magazine. At head of title: A practical guide to the production of visual articles. ', 'by Daniel D. Mich, executive editor [and] Edwin Eberman, art director, Look magazine.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Midgley, Mary ', 'Wisdom, information, and wonder', 'Wisdom, information, and wonder', 'Philosophy; Ordinary-language philosophy; ', 'Routledge', '1989', 'B72 .M48 1989', 'x, 275 p. ; 23 cm.', 'Mary Midgley. Spine title: Wisdom, information & wonder. Includes bibliographical references. ', 'Mary Midgley.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Miller, Benjamin Frank Keane, Claire (Brackman) ', 'Encyclopedia and dictionary of medicine and nursing', 'Encyclopedia and dictionary of medicine and nursing', 'Medicine; Dictionaries; Nursing; Dictionaries; ', 'Saunders', '1972', 'R121 .M65', 'x, 1089 p. illus. 27 cm.', 'by Benjamin F. Miller and Claire Brackman Keane. ', 'by Benjamin F. Miller and Claire Brackman Keane.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Miller, Max ', 'Mexico around me', 'Mexico around me', 'Description and travel; ', 'Reynal & Hitchcock', '[c1937]', 'F1215 .M68', '305 p. plates. 21 cm.', 'With illus. by Everett Gee Jackson. ', 'With illus. by Everett Gee Jackson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Milne, A. A. (Alan Alexander) Shepard, Ernest H. (Ernest Howard) ', 'The House at Pooh Corner', 'House at Pooh Corner', 'Toys; Fiction; ', 'Puffin Books', '1992', 'PZ7.M64 Ho 1992', '180 p. : ill. ; 20 cm.', 'A.A. Milne ; with decorations by Ernest H. Shepard. ', 'A.A. Milne ; with decorations by Ernest H. Shepard.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Milne, Lorus Johnson ', 'The mountains', 'mountains', 'Mountains; ', 'Time inc.', '[1962]', 'GB511 .M63', '192 p. illus. 28 cm.', 'by Lorus J. Milne and Margery Milne and the editors of Life. ', 'by Lorus J. Milne and Margery Milne and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Milne, A. A. (Alan Alexander) Shepard, Ernest H. (Ernest Howard) ', 'Now we are six', 'Now we are six', 'Childrens poetry, English; English poetry; ', 'Dutton Childrens Books', '[1988]', 'PR6025.I65 N63 1988', '101 p. : ill. ; 20 cm.', 'A.A. Milne ; with decorations by Ernest H. Shepard. ', 'A.A. Milne ; with decorations by Ernest H. Shepard.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Milne, A. A. (Alan Alexander) Shepard, Ernest H. (Ernest Howard) ', 'When we were very young', 'When we were very young', 'Childrens poetry, English; English poetry; ', 'Puffin Books', '1992', 'PR6025.I65 W5 1992', '100 p. : ill. ; 20 cm.', 'A.A. Milne ; with decorations by Ernest H. Shepard. Originally published: New York : E.P. Dutton, 1924. ', 'A.A. Milne ; with decorations by Ernest H. Shepard.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Milne, A. A. (Alan Alexander) Shepard, Ernest H. (Ernest Howard) ', 'Winnie the Pooh', 'Winnie the Pooh', 'Toys; Fiction; ', 'Puffin Books', '1992', 'PZ7.M64 Wi 1992', '161 p. : ill., map ; 20 cm.', 'A.A. Milne ; with decorations  by Ernest H. Shepard. ', 'A.A. Milne ; with decorations  by Ernest H. Shepard.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Minirth, Frank B. Newman, Brian. Warren, Paul ', 'The father book', 'father book', 'Fatherhood; Fathers; Father and child; ', 'T. Nelson Publishers', 'c1992', 'HQ756 .M56 1992', '286 p. ; 24 cm.', 'Frank Minirth, Brian Newman, Paul Warren. "A Janet Thoma Book" Includes bibliographical references (p. 280-283). ', 'Frank Minirth, Brian Newman, Paul Warren.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Montaigne, Michel de Frame, Donald Murdoch ', 'Selected essays', 'Selected essays', 'Translations into English; ', 'Pub. for the Classics club by W. J. Black', '[1943]', 'PQ1642.E6 F7', 'xxx p., 1 l., 364 p. illus. (incl. facsim.) 20 cm.', 'translated and with introduction and notes, by Donald M. Frame. At head of title: Michel de Montaigne. ', 'translated and with introduction and notes, by Donald M. Frame.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Montroll, John. ', 'Animal origami for the enthusiast', 'Animal origami for the enthusiast', 'Origami; ', 'Dover', '1985', 'TT870 .M55 1985', '119 p. : ill. ; 31 cm.', 'by John Montroll. ', 'by John Montroll.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Montroll, John. ', 'Origami for the enthusiast', 'Origami for the enthusiast', 'Origami; ', 'Dover Publications', '1979', 'TT870 .M56', '120 p. : chiefly ill. ; 31 cm.', 'by John Montroll. ', 'by John Montroll.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Montroll, John. Lang, Robert J. ', 'Origami sea life', 'Origami sea life', 'Origami; Fishes in art; ', 'Dover', '1991', 'TT870 .M572 1991', '192 p. : chiefly ill. ; 28 cm.', 'John Montroll, Robert J. Lang. Originally published: Maryland : Antroll Pub. Co., 1990. ', 'John Montroll, Robert J. Lang.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Moody, William Vaughn Lovett, Robert Morss ', 'A history of English literature', 'history of English literature', 'English literature; History and criticism. [from old catalog]; ', 'C. Scribners sons', '[c1926]', 'PR85 .M615 1926', 'xii, 547 p. incl. front. (map) 21 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Moore, Ruth E. ', 'Evolution', 'Evolution', 'Evolution; ', 'Time, inc.', '[1964]', 'QH367 .M82 1964', '192 p. illus. (part col.) ports. 28 cm.', 'by Ruth Moore and the editors of Life. Bibliography: p. 186. ', 'by Ruth Moore and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Morehead, Albert H. (Albert Hodges) Mott-Smith, Geoffrey Hoyle, Edmond ', 'Hoyles rules of games', 'Hoyles rules of games', 'Cards; Indoor games; ', 'New American Library', '[1963]', 'GV1243 .M62 1963', 'vi, 246 p. illus. 19 cm.', 'Edited by Albert H. Morehead and Geoffrey Mott-Smith. "KP 379." ', 'Edited by Albert H. Morehead and Geoffrey Mott-Smith.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Morgan, Dale Lowell ', 'Jedediah Smith and the opening of the West', 'Jedediah Smith and the opening of the West', 'Fur trade; Discovery and exploration; ', 'Bobbs-Merrill', '[1953]', 'F592 .S653', '458 p. illus., ports., map. 23 cm.', 'Bibliographical references included in "Notes" (p. 371-438) ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Morris, William ', 'The American Heritage dictionary of the English language', 'American Heritage dictionary of the English language', 'English language; Dictionaries; ', 'American Heritage Pub. Co.', '[1975]', 'PE1625 .A54 1975', 'L, 1550 p. : ill. ; 27 cm.', 'William Morris, editor. ', 'William Morris, editor.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Morris, William ', 'The American Heritage dictionary of the English language', 'American Heritage dictionary of the English language', 'English language; Dictionaries; ', 'American Heritage Pub. Co.', '[1969]', 'PE1625 .A54', 'l, 1550 p. illus., maps, ports. 29 cm.', 'William Morris, editor. ', 'William Morris, editor.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Morrison, Ross I. ', 'It happened in Lancaster County', 'It happened in Lancaster County', 'History; Biography; ', 'Rimjem Echoes', 'c1984', 'F157.L2 M74 1984', '62 p. : ill. ; 28 cm.', 'by Ross I. Morrison, Sr. Includes index. Bibliography: p. 59-60. ', 'by Ross I. Morrison, Sr.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Moulton, Sara Pierce, Charles ', 'Sara Moulton cooks at home', 'Sara Moulton cooks at home', 'Cookery; ', 'Broadway Books', 'c2002', 'TX714 .M717 2002', 'xv, 384 p., [16] p. of plates : ill. (some col.) ; 24 cm.', 'Sara Moulton ; recipes developed with Charles Pierce ; photography by Elizabeth Watt ; wine advice by Michael Green. Includes index. ', 'Sara Moulton ; recipes developed with Charles Pierce ; photography by Elizabeth Watt ; wine advice by Michael Green.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Muir, Kenneth. ', 'Shakespeare', 'Shakespeare', 'Hamlet (Legendary character); ', 'E. Arnold', '[1963]', 'PR2807 .M78 1963a', '61, [1] p. 20 cm.', 'Bibliography: p. [62] ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Mumford, Lewis ', 'Herman Melville', 'Herman Melville', '', 'The Literary Guild of America', '1929', 'PS2386 .M8 1929a', 'vi, 377 p. front. (port.) 23 cm.', '[by] Lewis Mumford. "Note on books": p. 369. ', '[by] Lewis Mumford.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Munitz, Milton Karl ', 'Theories of the universe', 'Theories of the universe', 'Cosmogony; Cosmology; ', 'Free Press', '[1957]', 'QB981 .M9', '437 p. illus. 25 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Musciano, Chuck. Kennedy, Bill ', 'HTML, the definitive guide', 'HTML, the definitive guide', 'HTML (Document markup language); ', 'OReilly', 'c1997', 'QA76.76.H94 M88 1997', 'xvii, 531 p. : ill. ; 24 cm.', 'Chuck Musciano and Bill Kennedy. Includes index. ', 'Chuck Musciano and Bill Kennedy.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Nahm, Milton Charles ', 'Aesthetic experience and its presuppositions', 'Aesthetic experience and its presuppositions', 'Aesthetics; Art; Philosophy; ', 'Harper', '[1946]', 'BH201 .N27', 'xiii, 554 p. 22 cm.', '[by] Milton C. Nahm. "First edition." Bibliography: p. [517]-540. ', '[by] Milton C. Nahm.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Nathan, Walter Ludwig ', 'Art and the message of the church', 'Art and the message of the church', 'Christian art and symbolism; ', 'Westminster Press', '[1961]', 'N7831 .N3', '208 p. illus. 21 cm.', 'Includes bibliography. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Negus, Chris ', 'Red Hat Linux 9 bible', 'Red Hat Linux 9 bible', 'Operating systems (Computers); ', 'Wiley Pub.', 'c2003', 'QA76.76.O63 N42675 2003', 'xxx, 1074 p. : ill. ; 24 cm. + 3 CD-ROMs (4 3/4 in.)', 'Christopher Negus. Includes index. System requirements for the accompanying CD-ROM: Pentium PC with 200 MHz or faster. ', 'Christopher Negus.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Nelson, John Herbert Cargill, Oscar ', 'Contemporary trends', 'Contemporary trends', 'American literature; ', 'Macmillan Co.', '1949', 'PS504 .A62 vol. 4', 'xiii, 1263 p. 22 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Newcomer, Alphonso G. (Alphonso Gerald) Andrews, Alice E. (Alice Ebba) Hall, Howard Judson ', 'Three centuries of American poetry and prose', 'Three centuries of American poetry and prose', 'American literature; ', 'Scott, Foresman and company', '[c1917]', 'PS507 .N4', 'x, 876 p. 22 cm.', 'selected and edited by Alphonso Gerald Newcomer ... Alice E. Andrews and Howard Judson Hall ... ', 'selected and edited by Alphonso Gerald Newcomer ... Alice E. Andrews and Howard Judson Hall ...');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Noad, Frederick M. [from old catalog] ', 'The Baroque guitar', 'Baroque guitar', 'Guitar music; Guitar music (Guitars (2)); Guitar music, Arranged; Guitar music (Guitars (2)), Arranged; Songs with guitar; ', '', '[1975] c1974', 'M125 .B3', '127 p. : ill. ; 28 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Noad, Frederick M. ', 'The Classical guitar', 'Classical guitar', 'Guitar music; Guitar music (Guitars (2)); Guitar music, Arranged; Songs with guitar; ', 'Ariel Music Publications', 'c1976', 'M125 .C57', '144 p. : ill. ; 28 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Noad, Frederick M. ', 'The Romantic guitar', 'Romantic guitar', 'Guitar music; ', 'Amsco Publications', '1986', 'M125 .R63 1986', '127 p. of music : ill. ; 31 cm.', 'selected and transcribed by Frederick Noad. Minimal level cataloging. ', 'selected and transcribed by Frederick Noad.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('North, Sterling ', 'George Washington', 'George Washington', '', 'Random House', '[c1957]', 'E312.66 .N6', '184 p. illus.', 'Illustrated by Lee Ames. ', 'Illustrated by Lee Ames.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Nourse, Alan Edward. ', 'The body', 'body', 'Human physiology; Human anatomy; ', 'Time, inc.', '[1964]', 'QP38 .N88', '200 p. illus. (part col.), ports. (part col.) 28 cm.', 'by Alan E. Nourse and the editors of Life. Bibliography: p. 196. ', 'by Alan E. Nourse and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('OBrien, Robert ', 'Machines', 'Machines', 'Machinery; ', 'Time, inc.', '[1964]', 'TJ147 .O2', '200 p. illus. (part col.) ports. 28 cm.', 'by Robert OBrien and the editors of Life. Bibliography: p. 196. ', 'by Robert OBrien and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('OConnor, Sharon Creider, Sarah. Metronote Quintet ', 'Bistro', 'Bistro', 'Cookery, French; Menus; Restaurants; Guidebooks; ', 'Menus and Music Productions', 'c1999', '', '248 p. : ill. ; 24 cm. + 1 sound disc (digital ; 4 3/4 in.).', 'by Sharon OConnor assisted by Sarah Creider. Accompanying sound disc contains jazz numbers which have some connection with Paris, performed by the Metronote Quintet. Includes index. ', 'by Sharon OConnor assisted by Sarah Creider.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('OConnor, Sharon Hodges, Frederick. ', 'Picnics', 'Picnics', 'Picnicking; Menus; Music festivals; Guidebooks; Music festivals; Guidebooks; ', 'Menus and Music Productions', '1994', 'TX823 .O26 1994', '247 p. : ill. ; 24 cm. + 1 sound disc (digital ; 4 3/4 in.).', 'Accompaning sound disc contains ragtime piano performed by Frederick Hodges; with the flute, violin, and cello of the Pickles and Peaches Ragtime Orchestra. Book and sound disc issued together in a case. Includes index. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ogden, C. K. (Charles Kay) Richards, I. A. (Ivor Armstrong) Wood, James Edward Hathorn ', 'The foundations of aesthetics', 'foundations of aesthetics', 'Aesthetics; ', 'Haskell House', '[1974]', 'BH201 .O5 1974', '92 p. illus. 23 cm.', '[by] I. A. Richards, C. K. Ogden [and] James Wood. Reprint of the 1925 ed. published by Lear Publishers, New York. Richards and Ogdens names in reverse order in 1922 London ed. Includes bibliographical references. ', '[by] I. A. Richards, C. K. Ogden [and] James Wood.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ommanney, F. D. (Francis Downes) Time-Life Books ', 'The fishes', 'fishes', 'Fishes; ', 'Time-Life Books', '[c1970]', 'QL617 .O4 1970', '192 p. illus. (part col.) 28 cm.', 'by F. D. Ommanney and the editors of Time-Life Books. Bibliography: p. 187. ', 'by F. D. Ommanney and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('ONeill, Molly. ', 'New York cookbook', 'New York cookbook', 'Cookery, American; Cookery, International; Cookery; Restaurants; ', 'Workman Publishing', 'c1992', 'TX715 .O533 1992', 'xv, 509 p. : ill. ; 24 cm.', 'by Molly ONeill ; photography by Howard Earl Simmons. Includes bibliographical references (p. 474-476) and index. ', 'by Molly ONeill ; photography by Howard Earl Simmons.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Osborne, Harold ', 'The Oxford companion to art', 'Oxford companion to art', 'Art; Dictionaries; Artists; Dictionaries; ', 'Clarendon P.', '1970', 'N33 .O9', 'xii, 1277 p., 2 plates. illus. (incl. 8 col.), plans. 25 cm.', 'edited by Harold Osborne. Bibliography: p. 1231-1277. ', 'edited by Harold Osborne.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ottman, Robert W. ', 'Elementary harmony', 'Elementary harmony', 'Harmony; ', 'Prentice-Hall', '[1970]', 'MT50 .O925E4 1970', 'x, 358 p. music. 24 cm.', '[by] Robert W. Ottman. ', '[by] Robert W. Ottman.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ottman, Robert W. [from old catalog] ', 'Music for sight singing', 'Music for sight singing', 'Sight-singing. [from old catalog]; ', 'Prentice-Hall', '[1967]', 'MT870 .O86 1967', 'xii, 265 p. 23 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ovid Thornton, J. C., [from old catalog] Thornton, M. J., [from old catalog] ', 'Selected works', 'Selected works', 'Translations into English; Epistolary poetry, Latin; Translations into English; Didactic poetry, Latin; Translations into English; Erotic poetry, Latin; Translations into English; Love poetry, Latin; Translations into English; Fables, Latin; Translations into English; Mythology, Classical; Poetry; ', 'J. M. Dent & sons ltd.', '[1939]', 'AC1 .E8 no. 955', 'xv, 432 p. 18 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Pan American World Airways, inc ', 'Pan Ams world guide', 'Pan Ams world guide', 'Travel; Guidebooks; ', 'McGraw-Hill', 'c1982', 'G153.4 .P36 1982', 'xix, 1163 p. : ill. ; 19 cm.', 'the encyclopedia of travel. Includes index. ', 'the encyclopedia of travel.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Parke, David B. ', 'The epic of Unitarianism', 'epic of Unitarianism', 'Unitarianism; ', 'Starr King Press', '[1957]', 'BX9813 .P3', '164 p. 22 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Parker, Bertha Morris. [from old catalog] ', 'The golden book encyclopedia', 'golden book encyclopedia', 'Childrens encyclopedias and dictionaries. [from old catalog]; ', 'Golden Press [1960-61; v.', '1, 1961; c1959]', 'AG5 .P27 1961', '16 v. (1536 p.) illus., col. ports., col. maps. 27 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Parker, De Witt H. (De Witt Henry) ', 'The principles of aesthetics', 'principles of aesthetics', 'Aesthetics; ', 'F. S. Crofts & Co.', '1946', 'BH201 .P35 1946', 'viii, 316 p. front., plates. 21 cm.', 'Bibliography: p. 298-302. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Parkhurst, Helen Huss ', 'Beauty', 'Beauty', 'Aesthetics; Art; ', 'Harcourt, Brace and Company', '[c1930]', 'N66 .P35', 'xi, 336 p. front., plates. 23 cm.', 'by Helen Huss Parkhurst ... "First edition." "References to authors quoted": p. 319-325. "A list of important titles for the study of aesthetics": p. 326-328. ', 'by Helen Huss Parkhurst ...');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Parrish, Carl Ohl, John F. ', 'Masterpieces of music before 1750', 'Masterpieces of music before 1750', 'Instrumental music; Vocal music; Music; History and criticism; ', 'Norton', '[1951]', 'M2.P25 M3', 'x, 235 p. 25 cm.', 'compiled and edited with historical and analytical notes by Carl Parrish and John F. Ohl. ', 'compiled and edited with historical and analytical notes by Carl Parrish and John F. Ohl.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Payne, Robert ', 'The dream and the tomb', 'dream and the tomb', 'Crusades; ', 'Scarborough House/Publishers', '1991', 'D157 .P35 1991', '421 p. : ill., maps ; 24 cm.', 'Robert Payne. Reprint. Originally published: New York :Stein and Day, 1984. Includes bibliographical references (p. 399-406) and index. ', 'Robert Payne.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Pendexter, Hugh ', 'The red road', 'red road', 'Braddocks Campaign, 1755; Fiction; ', 'The Bobbs-Merrill company', '[c1927]', 'PZ3.P3735 Red', '3 p. l., 314 p. 20 cm.', 'by Hugh Pendexter. ', 'by Hugh Pendexter.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Peterson, Roger Tory ', 'The birds', 'birds', 'Birds; ', 'Time inc.', '[1963]', 'QL676 .P444', '192 p. illus. (part col.) ports., col. maps. 28 cm.', 'by Roger Tory Peterson and the editors of Life. ', 'by Roger Tory Peterson and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Petroski, Henry. ', 'The book on the bookshelf', 'book on the bookshelf', 'Shelving for books; History; Shelving for books; History; Bookbinding; History; Bookbinding; History; Books; Storage; History; Books; Storage; History; ', 'Alfred A. Knopf', '1999', 'Z685 .P48 1999', 'x, 290 p. : ill. ; 25 cm.', 'by Henry Petroski. Includes bibliographical references (p. 269-277) and index. ', 'by Henry Petroski.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Petroski, Henry. ', 'The pencil', 'pencil', 'Pencils; History; ', 'Knopf', '1990', 'TS1268 .P47 1990', 'xi, 434 p. : ill. ; 24 cm.', 'by Henry Petroski. Includes index. Bibliography: p. 385-407. ', 'by Henry Petroski.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Petusevsky, Steve. ', 'The Whole Foods Market cookbook', 'Whole Foods Market cookbook', 'Cookery (Natural foods); Natural foods; ', 'Clarkson Potter', 'c2002', 'TX741 .P47 2002', 'xi, 450 p. : ill. ; 24 cm.', 'Steve Petusevsky and Whole Foods Market team members ; illustrations by David Watts. Includes bibliographical references (p. 433) and index. ', 'Steve Petusevsky and Whole Foods Market team members ; illustrations by David Watts.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Pfeiffer, John E. ', 'The cell', 'cell', 'Cytology; ', 'Time, inc.', '[1964]', 'QH581 .P38', '200 p. illus. (part col.) 28 cm.', 'by John Pfeiffer and the editors of Life. Bibliography: p. 196. ', 'by John Pfeiffer and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Philipson, Morris H. ', 'Aesthetics today', 'Aesthetics today', 'Art; Philosophy; Aesthetics; ', 'World Pub. Co.', '[1961]', 'N79 .P45', '475 p. illus. 19 cm.', 'readings selected, edited, and introduced by Morris Philipson. Includes bibliography. ', 'readings selected, edited, and introduced by Morris Philipson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Piper, Watty ', 'Folk tales children love', 'Folk tales children love', 'Tales; ', 'The Platt & Munk co., inc.', '[c1934]', 'PZ8.1.P661 Fo', '[78] p. col. front., illus. (part col.) 31 cm.', 'edited by Watty Piper. ', 'edited by Watty Piper.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Pirenne, Henri ', 'Medieval cities; their origins and the revival of trade', 'Medieval cities; their origins and the revival of trade', 'Cities and towns, Medieval; Commerce; History; ', 'Doubleday', '1956 [c1925]', 'JS61', '185 p. 18 cm.', 'Translated from the French by Frank D. Halsey. Translation of Les villes du Moyen Age. ', 'Translated from the French by Frank D. Halsey.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Place, Marian T. (Marian Templeton) ', 'Westward on the Oregon Trail', 'Westward on the Oregon Trail', 'Juvenile literature; Overland journeys to the Pacific; Juvenile literature; ', 'American Heritage Pub. Co.; book trade distribution by Meredith Press', 'c1962', 'F880 .P55', '153 p. illus. 27 cm.', 'by the editors of American Heritage. Narrative by Marian T. Place. Consultant: Earl Pomeroy. ', 'by the editors of American Heritage. Narrative by Marian T. Place. Consultant: Earl Pomeroy.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Platt, Colin. ', 'The castle in medieval England and Wales', 'castle in medieval England and Wales', 'Castles; History; Castles; History; Fortification; History; Fortification; History; Civilization; History; ', 'Scribner', '1982', 'DA660 .P55 1982', 'xiv, 210 p. : ill. ; 26 cm.', 'Colin Platt. Includes bibliographical references and index. ', 'Colin Platt.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Poe, Edgar Allan Peithman, Stephen. ', 'The annotated tales of Edgar Allan Poe', 'annotated tales of Edgar Allan Poe', 'Detective and mystery stories, American; Horror tales, American; ', 'Avenel', '1986, c1981', 'PS2612 .A1 1986', 'xv, 685 p. : ill. ; 29 cm.', 'edited with an introduction, notes, and a bibliography by Stephen Peithman. Includes index. Bibliography: p. 685. ', 'edited with an introduction, notes, and a bibliography by Stephen Peithman.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Polanyi, Michael ', 'Personal knowledge', 'Personal knowledge', 'Science; Philosophy; Knowledge, Theory of; ', 'University of Chicago Press', '[1958]', 'Q175 .P82', 'xiv, 428 p. 25 cm.', 'Bibliographical footnotes. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Poses, Steven. Clark, Anne. Roller, Becky. ', 'The frog commissary cookbook', 'frog commissary cookbook', 'Cookery; ', 'Doubleday', '1985', 'TX715 .P863 1985', 'xiii, 272 p. : ill. ; 26 cm.', 'by Steven Poses, Anne Clark, and Becky Roller ; illustrated by Becky Roller. Includes index. ', 'by Steven Poses, Anne Clark, and Becky Roller ; illustrated by Becky Roller.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Post, Emily Post, Elizabeth L. ', 'The new Emily Posts Etiquette', 'new Emily Posts Etiquette', 'Etiquette; ', 'Funk & Wagnalls', '[1975]', 'BJ1853 .P6 1975', 'xii, 978 p. illus. 24 cm.', 'by Elizabeth L. Post. Published in 1922 under title: Etiquette in society, in business, in politics and at home; in 1928: Etiquette, the blue book of social usage; in 1968: Etiquette. ', 'by Elizabeth L. Post.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Pounds, Norman John Greville. ', 'The medieval castle in England and Wales', 'medieval castle in England and Wales', 'Castles; History; Castles; History; Social conditions; Politics and government; History; ', 'Cambridge University Press', '1990', 'DA660 .P68 1990', 'xvii, 357 p. : ill., maps ; 26 cm.', 'N.J.G. Pounds. Includes bibliographical references (p. 301-342) and index. ', 'N.J.G. Pounds.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Prevost, Charlotte Kaminski. Wilder, Effie Leland ', 'Pawleys Island ... a living legend', 'Pawleys Island ... a living legend', 'History; ', 'State Print. Co.', '[1972]', 'F277.G35 P7', 'ix, 92 p. illus. 24 cm.', 'By Charlotte Kaminski Prevost and Effie Leland Wilder. Bibliography: p. 91. ', 'By Charlotte Kaminski Prevost and Effie Leland Wilder.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Prideaux, Tom. Time-Life Books ', 'The world of Whistler, 1834-1903', 'world of Whistler, 1834-1903', '', 'Time-Life Books', '[1970]', 'ND237.W6 P7', '191 p. illus., col. plates, ports. 32 cm.', 'by Tom Prideaux and the editors of Time-Life Books. Issued in a case. Bibliography: p. 187. ', 'by Tom Prideaux and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Progris, James. [from old catalog] ', 'Go for baroque with that jazz feeling', 'Go for baroque with that jazz feeling', '', 'C. Hansen', '[c1976]', 'M32.8 .G', '32 p. cm.', '[studies of original baroque melodies with jazz interpretations by Jim Progris]  For piano or organ. Melodies with chord symbols. ', '[studies of original baroque melodies with jazz interpretations by Jim Progris] ');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Pujol, Emilio ', 'Escuela razonada de la guitarra', 'Escuela razonada de la guitarra', 'Guitar; Methods. [from old catalog]; ', 'Ricordi Americana [1952-56; v.', '1, 1956]', 'MT582 .P84', '3 v. illus., music. 32 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rader, Melvin Miller Jessup, Bertram Emil ', 'Art and human values', 'Art and human values', 'Aesthetics; Values; Art; Philosophy; ', 'Prentice-Hall', 'c1976', 'BH201 .R28', 'x, 406 p. ; 24 cm.', 'Melvin Rader, Bertram Jessup ; with a foreword by Virgil C. Aldrich. Includes index. Bibliography: p. 387-397. ', 'Melvin Rader, Bertram Jessup ; with a foreword by Virgil C. Aldrich.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rader, Melvin Miller ', 'A modern book of esthetics', 'modern book of esthetics', 'Aesthetics; ', 'H. Holt and Company', '[c1935]', 'BH21 .R3', 'xxxv, 504 p. 22 cm.', 'edited, with introduction and notes, by Melvin M. Rader ... "Designed as a survey of recent esthetics."--Pref. Bibliography: p. [475]-495. ', 'edited, with introduction and notes, by Melvin M. Rader ...');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rand McNally and Company ', 'Rand McNally Cosmopolitan world atlas', 'Rand McNally Cosmopolitan world atlas', 'Atlases; ', 'Rand McNally', '[c1963]', 'G1019 .R24 1963', '1 atlas (1 v. (various pagings)) : ill., col. maps ; 37 cm.', 'Includes indexes. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Raymond, Eric S. ', 'The cathedral & the bazaar', 'cathedral & the bazaar', 'Operating systems (Computers); Computer software; Development; Computer hackers; ', 'OReilly', '1999', 'QA76.76.O63 R396 1999', 'xi, 268 p. ; 23 cm.', 'Eric S. Raymond, with a foreword by Bob Young. Includes bibliographical references. ', 'Eric S. Raymond, with a foreword by Bob Young.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Read, Ronald C. ', 'Tangrams', 'Tangrams', 'Tangrams; ', 'Dover Publications', '[1965]', 'GV1501.T3 R4 1965', '152 p. illus. 22 cm.', 'by Ronald C. Read. ', 'by Ronald C. Read.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Reavis, Dick J. ', 'Texas', 'Texas', 'Guidebooks; ', 'Compass American Guides', 'c1997', 'F384.3 .R43 1997', '332 p. : ill. (some col.), maps (some col.) ; 21 cm.', 'Dick J. Reavis ; photography by Will van Overbeek. Includes bibliographical references (p. 319-322) and index. ', 'Dick J. Reavis ; photography by Will van Overbeek.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rector, Johnny. ', 'Mel Bays deluxe encyclopedia of jazz guitar runs, fills, licks & lines', 'Mel Bays deluxe encyclopedia of jazz guitar runs, fills, licks & lines', 'Guitar; Studies and exercises (Jazz); Jazz; Instruction and study; ', 'Mel Bay', '[1998], c1984', 'MT585 .R318 1998', '83 p. of music ; 30 cm. + 1 sound disc (digital ; 4 3/4 in.)', 'by Johnny Rector. ', 'by Johnny Rector.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Reid, Louis Arnaud ', 'A study in aesthetics', 'study in aesthetics', 'Aesthetics; ', 'Macmillan', '1931', 'BH201 .R4', '415 p. 23 cm.', 'by Louis Arnaud Reid. ', 'by Louis Arnaud Reid.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Reinfeld, Fred ', 'Chess in a nutshell', 'Chess in a nutshell', 'Chess; ', 'Hanover House', '[1958]', 'GV1446 .R42', '143 p. illus. 22 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Remarque, Erich Maria Wheen, A. W. (Arthur Wesley) ', 'All quiet on the western front', 'All quiet on the western front', 'World War, 1914-1918; Fiction; ', 'Fawcett Columbine', '1996', 'PT2635.E68 I625 1996b', '295 p. ; 21 cm.', 'Erich Maria Remarque ; translated from the German by A. W. Wheen. ', 'Erich Maria Remarque ; translated from the German by A. W. Wheen.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Reninger, Marion Wallace ', 'Orange Street', 'Orange Street', 'Streets; Orange Street. [from old catalog]; ', '', 'c1954]', 'F159.L2 R4', '82 p. illus. 24 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rice, David Talbot Oates, David ', 'The dawn of European civilization', 'dawn of European civilization', 'History; Art, Medieval; Middle Ages; ', 'McGraw-Hill', '[1965]', 'CB351 .R46', '360 p. illus., facsims., geneal. tables, maps, plans, plates (part col.) 36 cm.', 'Texts by David Oates [and others] Includes bibliographical references. ', 'Texts by David Oates [and others]');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Richardson, John V. ', 'Knowledge-based systems for general reference work', 'Knowledge-based systems for general reference work', 'Reference services (Libraries); Automation; Expert systems (Computer science); ', 'Academic Press', 'c1995', 'Z711 .R554 1995', 'xix, 355 p. : ill. ; 24 cm.', 'John V. Richardson, Jr. Includes bibliographical references (p. 325-328) and index. ', 'John V. Richardson, Jr.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ripley, Sidney Dillon ', 'The land and wildlife of tropical Asia', 'land and wildlife of tropical Asia', 'Natural history; Natural history; ', 'Time, inc. [school and library distribution by Silver Burdett Co.', '1964]', 'QH179 .R5 1964', '200 p. illus. (part col.) col. maps. 28 cm.', 'by S. Dillon Ripley and the editors of Life. Bibliography: p. 193. ', 'by S. Dillon Ripley and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Robinson, Charles Alexander ', 'An anthology of Greek drama', 'anthology of Greek drama', 'Greek drama; Translations into English; ', 'Rinehart', '[1954]', 'PA3626.A2 R62', '398 p. 19 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rogers, Eric M. ', 'Physics for the inquiring mind', 'Physics for the inquiring mind', 'Physics; ', 'Princeton University Press', '1960', 'QC23 .R68', '778 p. illus. 29 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Chapman, Robert L. ', 'Rogets international thesaurus', 'Rogets international thesaurus', 'English language; Synonyms and antonyms; ', 'Harper & Row', '[1984], c1977', 'PE1591 .R73 1984', 'xxiv, 1316 p. : port. ; 23 cm.', 'Based on: Thesaurus of English words and phrases / by Peter Mark Roget. Includes index. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rombauer, Irma von Starkloff Becker, Marion Rombauer. Becker, Ethan. Guarnaschelli, Maria. ', 'Joy of cooking', 'Joy of cooking', 'Cookery, American; ', 'Scribner', 'c1997', 'TX715 .R75 1997', 'xiv, 1136 p. : ill. ; 25 cm.', 'by Irma S. Rombauer, Marion Rombauer Becker, and Ethan Becker ; illustrated by Laura Hartman Maestro. "Revised edition ... Maria Guarnaschelli ... senior editor"--Introd. Includes index. ', 'by Irma S. Rombauer, Marion Rombauer Becker, and Ethan Becker ; illustrated by Laura Hartman Maestro.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rombauer, Irma von Starkloff Becker, Marion Rombauer. ', 'Joy of cooking', 'Joy of cooking', 'Cookery, American; ', 'Bobbs-Merrill', '[1964]', 'TX715 .R75 1964', '849 p. illus. 23 cm.', '[by] Irma S. Rombauer [and] Marion Rombauer Becker.  Illustrated by Ginnie Hofmann and Beverly Warner. ', '[by] Irma S. Rombauer [and] Marion Rombauer Becker.  Illustrated by Ginnie Hofmann and Beverly Warner.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rosenfeld, Louis. Morville, Peter. ', 'Information architecture for the World Wide Web', 'Information architecture for the World Wide Web', 'Web sites; Design; Information storage and retrieval systems; Architecture; ', 'OReilly', '2002', 'TK5105.888 .R67 2002', 'p. cm.', 'Louis Rosenfeld & Peter Morville. Includes index. ', 'Louis Rosenfeld & Peter Morville.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rosenfeld, Louis. Morville, Peter. ', 'Information architecture for the World Wide Web', 'Information architecture for the World Wide Web', 'Web sites; Design; Information storage and retrieval systems; Architecture; ', 'OReilly', 'c1998', 'TK5105.888 .R67 1998', 'xix, 202 p. : ill. ; 24 cm.', 'Louis Rosenfeld and Peter Morville. Includes bibliographical references (p. 191-196) and index. ', 'Louis Rosenfeld and Peter Morville.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rosen, Robert N. ', 'A short history of Charleston', 'short history of Charleston', 'History; ', 'Lexikos', '1982', 'F279.C457 R67 1982', '160 p. : ill. ; 21 cm.', 'Robert N. Rosen. Includes index. Bibliography: p. 154-157. ', 'Robert N. Rosen.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rosso, Julee. Lukins, Sheila. ', 'The new basics cookbook', 'new basics cookbook', 'Cookery, American; ', 'Workman Pub.', 'c1989', 'TX715 .R8413 1989', 'xiii, 849 p. : ill. (some col.) ; 24 cm.', 'by Julee Rosso & Sheila Lukins ; illustrated by Sheila Lukins. Includes bibliographical references (p. 801-803) ', 'by Julee Rosso & Sheila Lukins ; illustrated by Sheila Lukins.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rosso, Julee. Lukins, Sheila. McLaughlin, Michael Silver Palate (Shop) ', 'The Silver Palate cookbook', 'Silver Palate cookbook', 'Cookery; ', 'Workman', 'c1982', 'TX715 .R8414 1982', 'xiii, 362 p. : ill. ; 26 cm.', 'by Julee Rosso & Sheila Lukins with Michael McLaughlin ; illustrated by Sheila Lukins. Includes index. ', 'by Julee Rosso & Sheila Lukins with Michael McLaughlin ; illustrated by Sheila Lukins.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rosso, Julee. Lukins, Sheila. Chase, Sarah Leah. Silver Palate (Shop) ', 'The Silver Palate good times cookbook', 'Silver Palate good times cookbook', 'Cookery; Entertaining; ', 'Workman Pub.', 'c1985', 'TX715 .R8415 1985', '414 p. : ill. ; 26 cm.', 'by Julee Rosso & Sheila Lukins with Sarah Leah Chase ; illustrated by Sheila Lukins. Includes index. ', 'by Julee Rosso & Sheila Lukins with Sarah Leah Chase ; illustrated by Sheila Lukins.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ross, Stewart. ', 'Scottish castles', 'Scottish castles', 'Castles; History; History, Military; ', 'Lochar Pub.', 'c1990', 'DA875 .R64 1990', '192 p. : ill. (some col.), maps ; 26 cm.', 'by Stewart Ross ; line illustrations by David Simon. Includes bibliographical references (p. 188) and index. ', 'by Stewart Ross ; line illustrations by David Simon.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Roszak, Theodore ', 'The cult of information', 'cult of information', 'Computers and civilization; ', 'Pantheon', 'c1986', 'QA76.9.C66 R66 1986', 'xii, 238 p. ; 24 cm.', 'Theodore Roszak. Includes index. Bibliography: p. 221-231. ', 'Theodore Roszak.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rowling, Marjorie. ', 'Everyday life in medieval times', 'Everyday life in medieval times', 'Middle Ages; History; Social history; ', 'Batsford', '1968', 'D127 .R6 1968', '227 p. illus., map. 23 cm.', 'Drawings by John Mansbridge. ', 'Drawings by John Mansbridge.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rowling, J. K. ', 'Harry Potter and the prisoner of Azkaban', 'Harry Potter and the prisoner of Azkaban', 'Wizards; Juvenile fiction; Magic; Juvenile fiction; Hogwarts School of Witchcraft and Wizardry (Imaginary place); Juvenile fiction; Schools; Juvenile fiction; Juvenile fiction; Wizards; Fiction; Magic; Fiction; Schools; Fiction; Fiction; ', 'Arthur A. Levine Books', '1999', 'PZ7.R79835 Ham 1999', 'ix, 435 p. : ill. ; 24 cm.', 'by J.K. Rowling. "Year 3"--Spine. Sequel to: Harry Potter and the Chamber of Secrets. ', 'by J.K. Rowling.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Roysdon, Christine. White, Howard D. ', 'Expert systems in reference services', 'Expert systems in reference services', 'Expert systems (Computer science); Reference services (Libraries); Automation; ', 'Haworth Press', 'c1989', 'Z678.93.E93 E96 1989', 'xvii, 238 p. : ill. ; 23 cm.', 'Christine Roysdon, Howard D. White, editors. "Has also been published as The Reference librarian, number 23, 1988"-- T.p. verso. Includes bibliographies. ', 'Christine Roysdon, Howard D. White, editors.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Rozin, Elisabeth. ', 'Blue corn and chocolate', 'Blue corn and chocolate', 'Cookery, International; Food; Gastronomy; ', 'Knopf', '1992', 'TX725.A1 R688 1992', 'xvi, 297 p. : ill. ; 26 cm.', 'by Elisabeth Rozin. Includes bibliographical references (p. 275-277) and index. ', 'by Elisabeth Rozin.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ruhe, Benjamin Darnell, Eric. ', 'Boomerang', 'Boomerang', 'Boomerangs; ', 'Workman Pub.', 'c1985', 'GV1097.B65 R84 1985', '93 p. : ill. ; 21 x 23 cm.', 'by Benjamin Ruhe and Eric Darnell ; illustrations by Cheslye Larson. Bibliography: p. 92-93. ', 'by Benjamin Ruhe and Eric Darnell ; illustrations by Cheslye Larson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Russell, Bertrand ', 'The problems of philosophy', 'problems of philosophy', 'Philosophy; Introductions; Metaphysics; Knowledge, Theory of; ', 'Oxford University Press', '1959', 'BD21 .R8 1959', '167 p. 21 cm.', 'Includes bibliography. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Russell, John Time-Life Books ', 'The world of Matisse, 1869-1954', 'world of Matisse, 1869-1954', '', 'Time-Life Books', '[1969]', 'ND553.M37 R8', '190 p. illus. (part col.), facsims., ports. 32 cm.', 'by John Russell and the editors of Time-Life Books. Bibliography: p. 185. ', 'by John Russell and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Ryan, Mildred Graves ', 'The complete encyclopedia of stitchery', 'complete encyclopedia of stitchery', 'Needlework; ', 'Doubleday', 'c1979', 'TT760 .R92', '689 p. : ill. ; 24 cm.', 'Mildred Graves Ryan ; ill. by Marta Cone Bibliography: p. 687-689. ', 'Mildred Graves Ryan ; ill. by Marta Cone');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Sagan, Carl ', 'Contact', 'Contact', '', 'Simon and Schuster', 'c1985', 'PS3569.A287 C6 1985', '432 p. ; 25 cm.', 'Carl Sagan. ', 'Carl Sagan.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Said, S. F. McKean, Dave ', 'Varjak Paw', 'Varjak Paw', 'Cats; Fiction; Family life; Fiction; Snobs and snobbishness; Fiction; Friendship; Fiction; Human-animal relationships; Fiction; Adventure and adventurers; Fiction; ', 'David Flicking Books', 'c2003', 'PZ7.S1325 Var 2003', '254 p. : ill. ; 24 cm.', 'S.F. Said ; illustrated by Dave McKean. ', 'S.F. Said ; illustrated by Dave McKean.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Samuels, Mike. Bennett, Hal Zina ', 'The well body book', 'well body book', 'Health; Medicine, Popular; ', 'Random House', '[1973]', 'RA776 .S2815', 'xv, 350 p. illus. 28 cm.', 'by Mike Samuels & Hal Bennett. Illustrated by Linda Bennett. "Random House/Bookworks." ', 'by Mike Samuels & Hal Bennett. Illustrated by Linda Bennett.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Santayana, George ', 'Reason in art', 'Reason in art', 'Aesthetics; Arts; Philosophy; ', 'Dover Publications', '1982', 'BH39 .S258 1982', 'ix, 230 p. ; 20 cm.', 'George Santayana. Reprint. Originally published: New York : Scribner, 1905. ', 'George Santayana.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Santayana, George ', 'The sense of beauty, being the outlines of aesthetic theory', 'sense of beauty, being the outlines of aesthetic theory', 'Aesthetics; ', 'Modern Library', '[1955]', 'B945.S23 S45 1955', 'xii, 268 p. 19 cm.', 'With a foreword by Philip Blair Rice. ', 'With a foreword by Philip Blair Rice.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Savola, Tom. Westenbroek, Alan. Heck, Joseph ', 'Using HTML', 'Using HTML', 'Hypertext systems; HTML (Document markup language); ', 'Que', 'c1995', 'QA76.76.H94 S25 1995', 'xxi, 673 p. : ill. ; 24 cm. + 1 computer laser optical disc (4 3/4 in.)', 'written by Tom Savola, with Alan Westenbroek, Joseph Heck. Includes index. System requirements for accompanying computer disc: for Dos, Windows, Mac, and UNIX. ', 'written by Tom Savola, with Alan Westenbroek, Joseph Heck.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Schickel, Richard. Time-Life Books ', 'The world of Goya, 1746-1828', 'world of Goya, 1746-1828', '', 'Time-Life Books', '[1968]', 'ND813.G7 S35', '192 p. illus. (part fold., part col.), map, ports. (part col.) 32 cm.', 'by Richard Schickel and the editors of Time-Life Books. Bibliography: p. 187. ', 'by Richard Schickel and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Schneider, Peter ', 'Taylors guide to roses', 'Taylors guide to roses', 'Rose culture; Roses; ', 'Houghton Mifflin Co.', '1995', 'SB411 .T33 1995', 'vii, 451 p. : ill. (some col.) ; 22 cm.', 'Peter Schneider, editor. Includes index. ', 'Peter Schneider, editor.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Schneider, Pierre. Time-Life Books ', 'The world of Watteau, 1684-1721', 'world of Watteau, 1684-1721', 'Social life and customs; Pictorial works; ', 'Time, inc.', '[1967]', 'ND553.W3 S35', '191 p. illus. (part col.) 31 cm.', 'by Pierre Schneider and the editors of Time-Life Books. Bibliography: p. 185. ', 'by Pierre Schneider and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Scholes, Percy Alfred ', 'The Oxford companion to music', 'Oxford companion to music', 'Music; Dictionaries; Music; Bio-bibliography; ', 'Oxford University Press', '1955', 'ML100 .S37 1955', 'lx, 1195 p. illus., ports., facsims., music. 25 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Schopenhauer, Arthur Saunders, Thomas Bailey ', 'Essays of Arthur Schopenhauer', 'Essays of Arthur Schopenhauer', '', 'Willey Book Company', '[191-?]', 'B3118.E5 S47', '[832] p. 21cm.', 'translated by T. Bailey Saunders, M.A. Various pagings. ', 'translated by T. Bailey Saunders, M.A.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Schopenhauer, Arthur Parker, De Witt H. (De Witt Henry) ', 'Selections', 'Selections', '', 'C. Scribners sons', '[c1928]', 'B3108 .P3', 'xxxii, 447 p. 17 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Schreibman, Phillip ', 'My cat saved my life', 'My cat saved my life', 'Cat owners; Psychology; Cats; Psychological aspects; Anecdotes; Human-animal relationships; Anecdotes; ', 'Dogs Bark Pub.', '1998', 'SF442.86 .S37 1998', 'xi, 113 p. ; 22 cm.', 'Phillip Schreibman. ', 'Phillip Schreibman.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Scott, Clinton Lee ', 'These live tomorrow', 'These live tomorrow', 'Unitarian churches; Biography; Biography; ', 'Beacon Press', '[1964]', 'BX9867 .S3', 'ix, 277 p. ports, 21 cm.', 'Illus. by Robert Mac Lean. ', 'Illus. by Robert Mac Lean.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Sehlinger, Bob Finley, John ', 'The unofficial guide to Walt Disney World', 'unofficial guide to Walt Disney World', 'Guidebooks; ', 'Menasha Ridge Press', 'c1985', 'GV1853.3.F62 O747 1985', 'x, 174 p. : ill. ; 21 cm.', 'Bob Sehlinger, John Finley. Includes indexes. Continued by the serial: Unofficial guide to Walt Disney World & EPCOT. ', 'Bob Sehlinger, John Finley.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Shafer, Jeremy. ', 'Origami to astonish and amuse', 'Origami to astonish and amuse', 'Origami; ', 'St. Martins Griffin', '2001', 'TT870 .S4443 2001', '251 p. : ill. (some col.) ; 28 cm.', 'Jeremy Shafer. ', 'Jeremy Shafer.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Shakespeare, William Knight, Charles Halliwell-Phillipps, J. O. (James Orchard) ', 'The complete works of Shakespeare', 'complete works of Shakespeare', '', 'Johnson, Fry, and company', '[1861?]', 'PR2754 .K7 1861', '3 v. fronts. (v. 1: port.) plates. 28 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Shakespeare, William Harbage, Alfred ', 'The complete works', 'complete works', '', 'Penguin Books', '[1969]', 'PR2754 .H33 1969', 'xxx, 1481 p. illus., facsims., port. 26 cm.', 'General editor: Alfred Harbage. Title on spine: The complete Pelican Shakespeare. "[Rev. ed. of] the Pelican text published in thirty-eight volumes between 1956 and 1967." Includes bibliographies. ', 'General editor: Alfred Harbage.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Shelley, Percy Bysshe Woodberry, George Edward ', 'The complete poetical works of Percy Bysshe Shelley', 'complete poetical works of Percy Bysshe Shelley', '', 'Houghton, Mifflin and company', '1901', 'PR5402  1901', 'xliii, 651 p. front. (port.) 21 cm.', 'Microfilm. Washington, D.C., Library of Congress. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Shure, Myrna B. DiGeronimo, Theresa Foy. ', 'Raising a thinking child', 'Raising a thinking child', 'Interpersonal conflict in children; Problem solving in children; Social skills in children; Child rearing; ', 'H. Holt', '1994', 'BF723.I645 S487 1994', 'xii, 212 p. : ill. ; 22 cm.', 'Myrna B. Shure wtih Theresa Foy DiGeronimo. "This book is about a research-based ... approach called I Can Problem Solve, or ISPS"--Introd. Includes bibliographical references (p. 202-203) and index. ', 'Myrna B. Shure wtih Theresa Foy DiGeronimo.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Sideman, Belle Becker Kredel, Fritz ', 'The worlds best fairy tales', 'worlds best fairy tales', 'Fairy tales; Fairy tales; Folklore; ', 'Readers Digest Association', '[1967]', 'PZ8.S34547 Wo', '832 p. col. illus. 21 cm.', 'Illus. by Fritz Kredel. ', 'Illus. by Fritz Kredel.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Silverman, Jerry. [from old catalog] ', 'Jerry Silvermans Ragtime guitar : complete instructions and exercises : 37 raggy songs with lyrics, music, and chords : 23 Scott Joplin rags, transcribed for guitar', 'Jerry Silvermans Ragtime guitar : complete instructions and exercises : 37 raggy songs with lyrics, music, and chords : 23 Scott Joplin rags, transcribed for guitar', 'Guitar; Methods (Ragtime) [from old catalog]; Guitar music, Arranged. [from old catalog]; ', ': Chappell Music Co.', 'c1976', 'MT582.S5334 J5', '191 p. ; 31 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Smith, Art ', 'Back to the table', 'Back to the table', 'Cookery, American; Dinners and dining; Family; ', 'Hyperion', 'c2001', 'TX715 .S65132 2001', '288 p. : ill. (some col.) : 24 cm.', 'Art Smith. Includes index. ', 'Art Smith.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Snicket, Lemony. Helquist, Brett ', 'The austere academy', 'austere academy', 'Orphans; Fiction; Brothers and sisters; Fiction; Boarding schools; Fiction; Schools; Fiction; Humorous stories; ', 'HarperCollins', '2000', 'PZ7.S6795 Au 2000', '221 p. : ill. ; 19 cm.', 'by Lemony Snicket ; illustrations by Brett Helquist. ', 'by Lemony Snicket ; illustrations by Brett Helquist.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Snow, C. P. (Charles Percy) ', 'Science and government', 'Science and government', 'Science and state; ', 'Harvard University Press', '1961', 'Q127.G4 S62 1961', '88 p. 21 cm.', 'Includes bibliography. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Snow, C. P. (Charles Percy) ', 'The two cultures: and a second look', 'two cultures: and a second look', 'Science and the humanities; ', 'University Press', '1964 [c1963]', 'AZ361 .S56 1964', '107 p. 20 cm.', '"An expanded version of [the authors] The two cultures and the scientific revolution." Bibliographical references included in "Notes" (p. 101-107) ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Society of American Archivists Library of Congress ', 'Encoded Archival Description tag library, version 2002', 'Encoded Archival Description tag library, version 2002', 'Encoded Archival Description (Document type definition); Handbooks, manuals, etc; ', 'Society of American Archivists', 'c2002', '', 'vi, 308 p. ; 28 cm.', 'prepared and maintained by the Encoded Archival Description Working Group of the Society of American Archivists and the Network Development and MARC Standards Office of the Library of Congress. "An essential tool for archivists, librarians, and allied professionals who either are learning EAD for the first time or converting their finding aids form version 1.0 to EAD 2002"--T.p. verso. Includes index. ', 'prepared and maintained by the Encoded Archival Description Working Group of the Society of American Archivists and the Network Development and MARC Standards Office of the Library of Congress.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Society of American Archivists ', 'Encoded Archival Description application guidelines', 'Encoded Archival Description application guidelines', 'Encoded Archival Description (Document type definition); Handbooks, manuals, etc; ', 'Society of American Archivists', '1999', 'Z695.2 .S63 1999', 'p. cm.', 'prepared by the Encoded Archival Description Working Group of the Society of American Archivists. Includes bibliographical references (p.   ) and index. ', 'prepared by the Encoded Archival Description Working Group of the Society of American Archivists.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Somerville, Annie. ', 'Fields of Greens', 'Fields of Greens', 'Vegetarian cookery; ', 'Bantam', 'c1993', 'TX837 .S683 1993', 'xxiv, 437 p. : col. ill. ; 27 cm.', 'Annie Somerville. Includes bibliograpical references (p. 423) and index. ', 'Annie Somerville.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Southern, Eileen. ', 'The music of black Americans', 'music of black Americans', 'African Americans; Music; History and criticism; Music; History and criticism; ', 'W. W. Norton', '[1971]', 'ML3556 .S74', 'xviii, 552 p. illus., facsims., music, ports. 22 cm.', '"Bibliography and discography": p. 511-532. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Sparshott, Francis Edward ', 'The future of aesthetics', 'future of aesthetics', 'Aesthetics; ', 'University of Toronto Press', 'c1998', 'BH39 .S633 1998', 'xii, 173 p. ; 24 cm.', 'Francis Sparshott. "Based on the 1996 Ryle lectures, delivered ... at Trent University in Peterborough, Ontario, on 11-14 March 1996"--Pref. Includes bibliographical references. ', 'Francis Sparshott.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Spieler, Marlena. ', 'Hot & spicy', 'Hot & spicy', 'Cookery, International; Spices; Condiments; ', 'J.P. Tarcher', 'c1985', 'TX725.A1 S63 1985', '230 p. : ill. ; 25 cm.', 'Marlena Spieler. Includes index. ', 'Marlena Spieler.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Spiller, Robert Ernest Blodgett, Harold William ', 'The roots of national culture', 'roots of national culture', 'American literature; American literature; American literature; ', 'Macmillan', '1949', 'PS504 .A62 vol. 1', 'xv, 998 p. 22 cm.', 'edited by Robert E. Spiller [and] Harold Blodgett. "Notes," containing biographical sketches and bibliographies: p. 893-992. ', 'edited by Robert E. Spiller [and] Harold Blodgett.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Spinoza, Benedictus de ', 'Ethics preceded by On the improvement of the understanding', 'Ethics preceded by On the improvement of the understanding', 'Ethics; ', 'Hafner Pub. Co.', '1949', 'B3973.E5 G87', '294 p.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Stanley, Thomas J. Danko, William D. ', 'The millionaire next door', 'millionaire next door', 'Rich people; Millionaires; ', 'Longstreet Press', 'c1996', 'HC110.W4 S73 1996', '258 p. ; 24 cm.', 'Thomas J. Stanley, William D. Danko. ', 'Thomas J. Stanley, William D. Danko.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Steinbeck, John ', 'Cannery row', 'Cannery row', 'Fiction; Fiction; Marine biologists; Fiction; Community life; Fiction; ', 'Penguin Books', '2002', 'PS3537.T3234 C3 2002', '181 p. ; 22 cm.', 'John Steinbeck. "John Steinbeck centennial edition (1902-2002)." ', 'John Steinbeck.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Stein, Lincoln D. ', 'How to set up and maintain a Web site', 'How to set up and maintain a Web site', 'World Wide web; Web sites; Design; Web servers; ', 'Addison-Wesley', 'c1997', 'TK5105.888 .S74 1997', 'xxi, 793 p. : ill. ; 24 cm. + 1 computer laser optical disc (4 3/4 in.)', 'Lincoln D. Stein. Includes index. System requirments for accompanying computer disc: UNIX systems; Windows 95; Windows NT 4.0, and the Macintosh. ', 'Lincoln D. Stein.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Stein, Jess M. ', 'The Random House dictionary of the English language', 'Random House dictionary of the English language', 'English language; Dictionaries; ', 'Random House', '[1966]', 'PE1625 .R3', 'xxxii, 2059 p. illus., maps. 32 cm.', 'Jess Stein, editor in chief. Laurence Urdang, managing editor. "The concise French dictionary": p. 1697-1743; "The concise Spanish dictionary": p. 1744-1790; "The concise Italian dictionary": p. 1791-1833; "The concise German dictionary": p. 1836-1895. "Atlas of the World" (p. [1961]-2059) includes 64 p. of col. maps. "Major reference works; a selected bibliography": p. 1906-1913. ', 'Jess Stein, editor in chief. Laurence Urdang, managing editor.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Stevenson, Robert Louis Price, Norman ', 'Treasure Island', 'Treasure Island', 'Buried treasure; Fiction; Pirates; Fiction; Adventure and adventurers; Fiction; ', 'Grosset & Dunlap', '[1994]', 'PZ7.S8482 Tr 1994', '342 p. : ill. (some col.) ; 24 cm.', 'by Robert Louis Stevenson ; text illustrated by Norman Price. ', 'by Robert Louis Stevenson ; text illustrated by Norman Price.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Stever, H. Guyford. Haggerty, James J. ', 'Flight', 'Flight', 'Aeronautics; Popular works; ', 'Time inc.', '[1965]', 'TL546.7 .S86', '200 p. illus. (part col.) 29 cm.', 'by H. Guyford Stever, James J. Haggerty and the editors of Life. Bibliography: p. 196. ', 'by H. Guyford Stever, James J. Haggerty and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Stewart, Hilary. ', 'Totem poles', 'Totem poles', 'Totem poles; Indian sculpture; ', 'University of Washington Press', 'c1990', 'E98.T6 S74 1990', '192 p. : ill., maps ; 24 x 26 cm.', 'written & illustrated by Hilary Stewart. Includes bibliographical references (p. 185) and index. ', 'written & illustrated by Hilary Stewart.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Stine, R. L. Scholastic Inc Copyright Paperback Collection (Library of Congress) ', 'The werewolf of Fever Swamp', 'werewolf of Fever Swamp', '', 'Scholastic Inc.', 'c1993', 'MLC R CP01334', '123 p. ; 19 cm.', 'R.L. Stine. "An Apple paperback". Source: Copyright deposit, Jan. 13, 1994. ', 'R.L. Stine.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Stringham, Edwin John ', 'Listening to music creatively', 'Listening to music creatively', 'Music appreciation; ', 'Prentice-Hall, inc.', '1946', 'MT6 .S815 1946', 'xx, 479 p. front., illus. (incl. ports., music) 24 cm.', '[by] Edwin J. Stringham. A preliminary wartime edition by E. J. Stringham and John Machlis was published in 1943. ', '[by] Edwin J. Stringham.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Strode, Hudson ', 'Timeless Mexico', 'Timeless Mexico', 'History; ', 'Harcourt, Brace and company', '[1944]', 'F1226 .S8', '436 p.', 'Bibliography: p. 425-430. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Stumpf, Samuel Enoch ', 'Socrates to Sartre', 'Socrates to Sartre', 'Philosophy; History; ', 'McGraw-Hill', '[1966]', 'B72 .S79', 'viii, 510 p. 24 cm.', 'Bibliography: p. [471]-490. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Sundara Rao, T. (Tandalam) Beman, Wooster Woodruff Smith, David Eugene ', 'Geometric exercises in paper folding', 'Geometric exercises in paper folding', 'Geometry; Study and teaching; Paper work; ', 'Dover publications', '[1966]', 'QA462 .S8 1966', '148 p. illus. 22 cm.', 'by T. Sundara Row. Edited and revised by Wooster Woodruff Beman and David Eugene Smith. ', 'by T. Sundara Row. Edited and revised by Wooster Woodruff Beman and David Eugene Smith.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Taber, Ed Klutz Press ', 'The Klutz book of card games', 'Klutz book of card games', 'Card games; ', 'Klutz Press', 'c1990', 'GV1243 .K58 1990', '113 p. : ill. ; 22 cm. + 1 drawstring bag containing 1 deck of cards.', 'by the editors of Klutz Press ; [cartoons, Ed Taber]. "A compendium of the 20 most popular card games in the galaxy, as well as two knock-em-dead card tricks and complete blueprints to a three-bedroom house of cards." ', 'by the editors of Klutz Press ; [cartoons, Ed Taber].');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Tannahill, Reay. ', 'Sex in history', 'Sex in history', 'Sex customs; History; ', 'Stein and Day', '1980', 'HQ12 .T27', '480 p. : ill. ; 24 cm.', 'Reay Tannahill. Includes index. Bibliography: p. 427-444. ', 'Reay Tannahill.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Tanner, J. M. (James Mourilyan) Taylor, Gordon Rattray ', 'Growth', 'Growth', 'Growth; ', 'Time, inc.', '[1965]', 'QP84 .T24', '200 p. illus. (part col.) 28 cm.', 'by James M. Tanner, Gordon Rattray Taylor and the editors of Life. Bibliography: p. 194. ', 'by James M. Tanner, Gordon Rattray Taylor and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Taylor, Arlene G. ', 'The organization of information', 'organization of information', 'Information organization; Metadata; ', 'Libraries Unlimited', '1999', 'Z666.5 .T39 1999', 'xx, 280 p. ; 26 cm.', 'Arlene G. Taylor. Includes bibliographical references and index. ', 'Arlene G. Taylor.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Temko, Florence. Jackson, Paul ', 'Paper pandas and jumping frogs', 'Paper pandas and jumping frogs', 'Paper work; ', 'China Books & Periodicals', '1986', 'TT870 .T462 1986', '135 p. : ill. (some col.) ; 28 cm.', 'by Florence Temko ; illustrations by Paul Jackson and Florence Temko ; photos by Richard Peterson and David Friend. Includes index. ', 'by Florence Temko ; illustrations by Paul Jackson and Florence Temko ; photos by Richard Peterson and David Friend.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Thompson, Philip Duncan. OBrien, Robert Time-Life Books ', 'Weather', 'Weather', 'Weather; Meteorology; Weather; ', 'Time-Life Books', '[1968]', 'QC981.2 .T47 1968', '200 p. ill., maps (all part col.) 29 cm.', 'by Philip D. Thompson, Robert OBrien, and the editors of Time-Life Books. Bibliography: p. 196. ', 'by Philip D. Thompson, Robert OBrien, and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Thoreau, Henry David ', 'Walden', 'Walden', 'Homes and haunts; Authors, American; Homes and haunts; Social life and customs; Wilderness areas; Natural history; Authors, American; Biography; Solitude; ', 'C. E. Merrill', '[1969]', 'PS3048 .A1 1969b', 'xix, 357 p. 23 cm.', 'Introduced by Willard Thorp. "The text of the first printing." ', 'Introduced by Willard Thorp.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Tichenor, Trebor Jay. [from old catalog] ', 'Ragtime rarities : complete orginial music for 63 piano rags', 'Ragtime rarities : complete orginial music for 63 piano rags', 'Piano music (Ragtime) [from old catalog]; ', '', 'c1975', 'M21 .R218', 'xiv, 305 p. : facsims. ; 31 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Time-Life Books ', 'American painting, 1900-1970', 'American painting, 1900-1970', 'Painting, American; ', '', '[c1970]', 'ND212 .T5', '192 p. illus. (part col.), ports. 32 cm.', 'by the editors of Time-Life Books. Bibliography: p. 187. ', 'by the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Time-Life Books ', 'The Holy Land', 'Holy Land', 'Antiquities; Antiquities; Excavations (Archaeology); History; ', 'Time-Life Books', 'c1992', 'DS111 .H65 1992', '168 p. : col. ill., maps ; 28 cm.', 'by the editors of Time-Life Books. Maps on lining papers. Includes bibliographical references (p. 161-163) and index. ', 'by the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Time-Life Books ', 'The Magnificent Maya', 'Magnificent Maya', 'Mayas; Antiquities; Antiquities; Antiquities; ', 'Time-Life Books', 'c1993', 'F1435 .M35 1993', '168 p. : ill. (some col.) ; 29 cm.', 'by the editors of Time-Life Books. Includes bibliographical references (p. 163-165) and index. ', 'by the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Time-Life Books ', 'Ramses II', 'Ramses II', 'History; Antiquities; ', 'Time-Life Books', 'c1993', 'DT87 .R34 1993', '168 p. : ill. (some col.), col. maps ; 29 cm.', 'by the editors of Time-Life Books. Includes bibliographical references (p. 162-163) and index. ', 'by the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Time-Life Books ', 'Seven centuries of art', 'Seven centuries of art', 'Art; History; Art; Indexes; ', '', '[c1970]', 'N6350 .T5', '191 p. illus. (part col.) 32 cm.', 'by the editors of Time-Life Books. Issued in slipcase. ', 'by the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Time-Life Books ', 'Vikings', 'Vikings', 'Vikings; Northmen; ', 'Time-Life Books', 'c1993', 'DL65 .V585 1993', '168 p. : ill. (some col.), col. maps ; 29 cm.', 'by the Editors of Time-Life Books. Includes bibliographical references (p. 161-164) and index. ', 'by the Editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Time-Life Books ', 'Wondrous realms of the Aegean', 'Wondrous realms of the Aegean', 'Antiquities; Civilization, Aegean; Bronze age; Excavations (Archaeology); ', 'Time-Life Books', 'c1993', 'DF220 .W66 1993', '167 p. : ill. (some col.), maps ; 28 cm.', 'by the editors of the Time-Life Books. Includes bibliographical references (p. 162-163) and index. ', 'by the editors of the Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Tinbergen, Niko ', 'Animal behavior', 'Animal behavior', 'Animal behavior; ', 'Time Inc.', '[1965]', 'QL751 .T54', '200 p. illus. (part col.) ports. 28 cm.', 'by Niko Tinbergen and the editors of Life. ', 'by Niko Tinbergen and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Tirro, Frank. ', 'Jazz', 'Jazz', 'Jazz; History and criticism; ', 'Norton', 'c1977', 'ML3561.J3 T5', 'xix, 457 p. : ill. ; 25 cm.', 'by Frank Tirro. Includes index. Bibliography: p. 403-426. Discography: p. 427-430. ', 'by Frank Tirro.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Tomkins, Calvin Time-Life Books ', 'The world of Marcel Duchamp, 1887-1968', 'world of Marcel Duchamp, 1887-1968', 'Surrealism; ', 'Time-Life Books', 'c1977', 'N6853.D8 T6 1977', '192 p. : ill. (some col.) ; 31 cm.', 'by Calvin Tomkins and the editors of Time-Life Books. Includes index. Bibliography: p. 185. ', 'by Calvin Tomkins and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Toy, Sidney. ', 'Castles', 'Castles', 'Fortification; History; Fortification; History; Castles; History; Castles; History; ', 'Dover Publications', '1985', 'UG428 .T69 1985', 'xiv, 241 p. : ill. ; 24 cm.', 'Sidney Toy. Reprint. Originally published: London : W. Heinemann, 1939. Includes bibliographical references and index. ', 'Sidney Toy.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Travis, Debbie. Dingle, Barbara. ', 'Debbie Travis painted house', 'Debbie Travis painted house', 'House painting; Amateurs manuals; Furniture painting; Amateurs manuals; Interior decoration; Amateurs manuals; ', 'C. Potter', 'c1997', 'TT323 .T73 1997', '184 p. : col. ill. ; 29 cm.', 'Debbie Travis with Barbara Dingle. Includes index. ', 'Debbie Travis with Barbara Dingle.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Tropp, Barbara. Schreil, Arminda Asprer. ', 'China Moon cookbook', 'China Moon cookbook', 'Cookery, Chinese; Cookery, American; ', 'Workman Publishing', 'c1992', 'TX724.5.C5 T684 1992', 'x, 518 p. : ill. ; 24 cm.', 'by Barbara Tropp, assisted by Arminda Asprer Schreil ; dessert and bread recipes by Amy Ho ; illustrations by Sandra Bruce. Includes index. ', 'by Barbara Tropp, assisted by Arminda Asprer Schreil ; dessert and bread recipes by Amy Ho ; illustrations by Sandra Bruce.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Twain, Mark ', 'The complete short stories of Mark Twain now collected for the first time', 'complete short stories of Mark Twain now collected for the first time', 'Humorous stories, American; Social life and customs; Fiction; ', 'Hanover House', '1957', 'PZ3.C59 Cm', 'xxiv, 676 p. 22 cm.', 'Edited with an introd. by Charles Neider. ', 'Edited with an introd. by Charles Neider.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Unitarian Universalist Association ', 'Singing the living tradition', 'Singing the living tradition', 'Hymns; Hymns, English; ', 'Beacon Press', 'c1993', 'M2131.U5 S45 1993b', '1 close score (viii, 686 p.) ; 23 cm.', 'Includes indexes. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('University of Chicago ', 'A manual of style', 'manual of style', 'Printing; Style manuals; Authorship; Style manuals; ', 'University of Chicago Press', 'c1969', 'Z253 .C5714 1969', 'ix, 546 p. : ill. ; 24 cm.', 'Includes index. Rev. ed. published as: The Chicago manual of style. 13th ed., rev. and expanded. 1982. Bibliography: p. 513-520. ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Vromans, Johan. ', 'Perl 5 pocket reference', 'Perl 5 pocket reference', 'Perl (Computer program language); ', 'OReilly', 'c1998', 'QA76.73.P22 V76 1998', '67 p. ; 18 cm.', 'Johan Vromans. ', 'Johan Vromans.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wagenbach, Klaus. ', 'Franz Kafka', 'Franz Kafka', 'Pictorial works; Authors, Austrian; Pictorial works; ', 'Pantheon Books', 'c1984', 'PT2621.A26 Z97613 1984', '221 p. : ill., ports ; 25 cm.', 'Klaus Wagenbach ; translated from the German by Arthur S. Wensinger. ', 'Klaus Wagenbach ; translated from the German by Arthur S. Wensinger.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wallace, Robert Time-Life Books ', 'The world of Bernini, 1598-1680', 'world of Bernini, 1598-1680', '', 'Time-Life Books', '[c1970]', 'NB623.B5 W3 1970', '192 p. illus. (part col.) 31 cm.', 'by Robert Wallace and the editors of Time-Life Books. Bibliography: p. 185. ', 'by Robert Wallace and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wallace, Robert Time-Life Books ', 'The world of Rembrandt, 1606-1669', 'world of Rembrandt, 1606-1669', '', 'Time-Life Books', '[1968]', 'ND653.R4 W27 1968', '188 p. illus. (part col.) 31 cm.', 'by Robert Wallace and the editors of Time-Life Books. Issued in a case. Bibliography: p. 183. ', 'by Robert Wallace and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wallace, Robert Time-Life Books ', 'The world of Van Gogh, 1853-1890', 'world of Van Gogh, 1853-1890', 'Painters; Biography; ', 'Time-Life Books', '[1969]', 'ND653.G7 W34', '192 p. illus. (part col.), ports. 32 cm.', 'by Robert Wallace and the editors of Time-Life Books. Bibliography: p. 184. ', 'by Robert Wallace and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wallace, Robert ', 'The world of Leonardo, 1452-1519', 'world of Leonardo, 1452-1519', '', 'Time, inc.', '[1966]', 'ND623.L5 W32', '192 p. illus. (part col.) 32 cm.', 'by Robert Wallace and the editors of Time-Life Books. Bibliography: p. 187-188. ', 'by Robert Wallace and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wall, Larry. Schwartz, Randal L. Christiansen, Tom. ', 'Programming Perl', 'Programming Perl', 'Perl (Computer program language); Programming Languages; ', 'OReilly & Associates', 'c1996', 'QA76.73.P22 W35 1996', 'xxi, 645 p. ; 23 cm.', 'Larry Wall, Tom Christiansen, and Randal L. Schwartz, with Stephen Potter. "Programming"--Cover. Includes index. ', 'Larry Wall, Tom Christiansen, and Randal L. Schwartz, with Stephen Potter.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wall, Larry. Schwartz, Randal L. ', 'Programming Perl', 'Programming Perl', 'Perl (Computer program language); ', 'OReilly & Associates', 'c1991', 'QA76.73.P22 W35 1991', 'xxi, 465 p. ; 23 cm.', 'Larry Wall and Randal L. Schwartz. Accompanied by booklet "Quick reference guide" (19 p. ; 21 cm) inserted at end. "Unix programming"--Cover. Includes index. ', 'Larry Wall and Randal L. Schwartz.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Walsh, Norman. Muellner, Leonard. ', 'DocBook', 'DocBook', 'SGML (Document markup language); XML (Document markup language); ', 'OReilly & Associates', 'c1999', 'QA76.76.H94 W35 1999', 'xii, 635 p. : ill. ; 23 cm. + 1 computer laser optical disc (4 3/4 in.)', 'Norman Walsh and Leonard Muellner. Includes index. ', 'Norman Walsh and Leonard Muellner.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Waltuck, David. Phillips, Melicia. ', 'Staff meals from Chanterelle', 'Staff meals from Chanterelle', 'Cookery; ', 'Workman Pub.', '2000', 'TX714 .W264 2000', 'xvi, 448 p. : ill. ; 25 cm.', 'David Waltuck and Melicia Phillips ; photographs by Maria Robledo. Includes index. ', 'David Waltuck and Melicia Phillips ; photographs by Maria Robledo.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wann, Louis ', 'The rise of realism', 'rise of realism', 'American literature; ', 'Macmillan', '1949', 'PS504 .A62 vol. 3', 'xv, 874 p.  22 cm.', 'Biographical sketches and bibliographies included in "Notes" (p. 817-868) ', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Washington, Joe. [from old catalog] ', 'The Beatles for classical guitar', 'Beatles for classical guitar', 'Guitar; Instruction and study. [from old catalog]; ', '', '[1974]', 'MT580 .B42', '8 : p. ; 28 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wedge, George Anson. [from old catalog] ', 'Keyboard harmony', 'Keyboard harmony', 'Harmony. [from old catalog]; ', 'G. Schirmer, inc.', '[c1924]', 'MT50 .W391', 'vi, 194 p. 2 fold. tab. 27 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wedgwood, C. V. (Cicely Veronica) Time-Life Books ', 'The world of Rubens, 1577-1640', 'world of Rubens, 1577-1640', '', 'Time, inc.', '[1967]', 'ND673.R9 W4', '192 p. illus. (part col.) 31 cm.', 'by C. V. Wedgwood and the editors of Time-Life Books. Bibliography: p. 187. ', 'by C. V. Wedgwood and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Went, Frits Warmolt ', 'The plants', 'plants', 'Botany; ', 'Time, inc.', '[1963]', 'QK50 .W43', '194 p. illus. (part col.) 28 cm.', 'by Frits W. Went and the editors of Life. Bibliography: p. 188. ', 'by Frits W. Went and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wertenbaker, Lael Tucker Time-Life Books ', 'The world of Picasso (1881- )', 'world of Picasso (1881- )', '', 'Time-Life Books', '[1967]', 'ND553.P5 W45', '190 p. illus. (part col., part fold.), ports. (part col.) 31 cm.', 'by Lael Wertenbaker and the editors of Time-Life Books. Bibliography: p. 185-186. ', 'by Lael Wertenbaker and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wheeler, Tom (Thomas Hutchin) ', 'American guitars', 'American guitars', 'Guitar; History; ', 'Harper & Row', 'c1982', 'ML1015.G9 W5 1982', 'xiv, 370 p. : ill. ; 29 cm.', 'Tom Wheeler. Includes index. ', 'Tom Wheeler.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('White, Morton Gabriel ', 'The age of analysis', 'age of analysis', 'Philosophy, Modern; ', 'Books for Libraries Press', '[1970, c1955]', 'B804.A1 W5 1970', '253 p. 23 cm.', 'selected, with an introd. and interpretive commentary, by Morton White. Includes bibliographical references. ', 'selected, with an introd. and interpretive commentary, by Morton White.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Whitehead, Alfred North ', 'Science and the modern world', 'Science and the modern world', 'Science; ', 'Free Press', '[1967]', 'Q175 .W65 1967', 'ix, 212 p. 21 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Whitman, Walt ', 'Leaves of grass, and selected prose', 'Leaves of grass, and selected prose', '', 'Modern Library', '[1950]', 'PS3200 .F50', 'xxix, 769 p. 19 cm.', 'Edited with an introd. by John Kouwenhoven. "Bibliographical note": p.xix ', 'Edited with an introd. by John Kouwenhoven.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Whitman, Walt Cowley, Malcolm Charles E. Feinberg Collection of Walt Whitman (Library of Congress) ', 'Walt Whitmans Leaves of grass', 'Walt Whitmans Leaves of grass', '', 'Viking Press', '1959', 'PS3201  1959', 'xxxvii, 145 p. : facsim., port. ; 25 cm.', 'edited, with an introduction, by Malcolm Cowley. ', 'edited, with an introduction, by Malcolm Cowley.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wiener, Philip P. (Philip Paul) ', 'Dictionary of the history of ideas', 'Dictionary of the history of ideas', 'Civilization; ', 'Scribner', '[1973-74]', 'CB5 .D52', '5 v. 29 cm.', 'Philip P. Wiener, editor in chief. Includes bibliographies. ', 'Philip P. Wiener, editor in chief.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Williams, Robin ', 'Beyond The Mac is not a typewriter', 'Beyond The Mac is not a typewriter', 'Computerized typesetting; Desktop publishing; ', 'Peachpit Press', 'c1996', 'Z253.3 .W55 1996', 'xiii, 222 p. ; 24 cm.', 'Robin Williams. Includes index. ', 'Robin Williams.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Williams, Jay Time-Life Books ', 'The world of Titian, c. 1488-1576', 'world of Titian, c. 1488-1576', '', 'Time-Life Books', '[1968]', 'ND623.T7 W5', '192 p. illus. (part col.) 31 cm.', 'by Jay Williams and the editors of Time-Life Books. In case. Bibliography: p. 187. ', 'by Jay Williams and the editors of Time-Life Books.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Willinger, Faith Heller. ', 'Red, white & greens', 'Red, white & greens', 'Cookery (Vegetables); Cookery, Italian; ', 'HarperCollins', '1996', 'TX801 .W528 1996', 'xii, 339 ; 24 cm.', 'Faith Willinger. Includes index. ', 'Faith Willinger.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wilson, Mitchell A. ', 'Energy', 'Energy', 'Power (Mechanics); ', 'Time, inc.', '[c1963]', 'TJ147 .W53', '200 p. illus. (part col.), ports. 28 cm.', 'by Mitchell Wilson and the editors of Life. Bibliography: p. 196. ', 'by Mitchell Wilson and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wilson, John Rowan ', 'The mind', 'mind', 'Mind and body; Psychophysiology; ', 'Time, inc.', '[1964]', 'BF161 .W49', '200 p. illus. (part col.) 28 cm.', 'by John Rowan Wilson and the editors of Life. Bibliography: p. 196. ', 'by John Rowan Wilson and the editors of Life.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wilson, Johnny L. ', 'The SimCity planning commission handbook', 'SimCity planning commission handbook', 'City planning; Computer simulation; City planning; Simulation games; Computer games; ', 'Osborne McGraw-Hill', 'c1990', 'IN PROCESS (ONLINE)', 'xxvii, 193 p. : ill. ; 24 cm.', 'Johnny L. Wilson. Includes bibliographical references (p. 185-187) and index. ', 'Johnny L. Wilson.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wollitz, Kenneth. ', 'The recorder book', 'recorder book', 'Recorder (Musical instrument); Instruction and study; ', 'Knopf', '1982, c1981', 'MT350 .W64 1982', 'xxv, 259 p. : ill. ; 24 cm.', 'Kenneth Wollitz. Includes index. Bibliography: p. [252]-255. ', 'Kenneth Wollitz.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wong, Clinton. ', 'Web client programming with Perl', 'Web client programming with Perl', 'Internet programming; Perl (Computer program language); Client/server computing; World Wide Web; ', 'OReilly', 'c1997', 'QA76.625 .W66 1997', 'xii, 213 p. : ill ; 23 cm.', 'Clinton Wong. Includes index. ', 'Clinton Wong.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wood, Jerome H. Pennsylvania Historical and Museum Commission ', 'Conestoga crossroads, Lancaster, Pennsylvania, 1730-1790', 'Conestoga crossroads, Lancaster, Pennsylvania, 1730-1790', 'History; History; ', 'Commonwealth of Pennsylvania, Pennsylvania Historical and Museum Commission', '1979', 'F159.L2 W66', 'xi, 305 p. : ill., map (on lining paper) ; 24 cm.', 'by Jerome H. Wood, Jr. Includes index. Bibliography: p. 287-296. ', 'by Jerome H. Wood, Jr.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wood, Michael ', 'In search of the Dark Ages', 'In search of the Dark Ages', 'History; Civilization; Anglo-Saxons; ', 'Facts on File', 'c1987', 'DA135 .W83 1987', '250 p. : ill. ; 26 cm.', 'Michael Wood. Includes index. Bibliography: p. 243-244. ', 'Michael Wood.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Woolley, Al E. ', 'Photographic lighting', 'Photographic lighting', 'Photography; Portraits; Lighting and posing; ', 'Barnes', '[1963]', 'TR590 .W6', '154 p. illus., ports. 26 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Worthington, Diane Rossen. ', 'Seriously simple', 'Seriously simple', 'Quick and easy cookery; ', 'Chronicle Books', 'c2002', 'TX833.5 .W675 2002', '191 p. : col. ill. ; 23 cm.', 'by Diane Rossen Worthington ; photographs by Noel Barnhurst. Includes index. ', 'by Diane Rossen Worthington ; photographs by Noel Barnhurst.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wright, Conrad. ', 'The beginnings of Unitarianism in America', 'beginnings of Unitarianism in America', 'Unitarian Universalist churches; History; Unitarian churches; History; Unitarianism; History; ', 'Archon Books', '1976, c1955', 'BX9833 .W7 1976', '305 p. : maps ; 23 cm.', 'Conrad Wright. Reprint of the 1966 ed. published by Beacon Press, Boston. A revision of the authors thesis, Harvard University. Includes index. Bibliography: p. [292]-294. ', 'Conrad Wright.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Wurman, Richard Saul ', 'Information anxiety', 'Information anxiety', 'Communication; Mass media; ', 'Doubleday', '1989', 'P90 .W8 1989', '356 p. : ill. (some col.) ; 25 cm.', 'Richard Saul Wurman. Bibliography: p. 339-348. ', 'Richard Saul Wurman.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Yarger, Randy Jay. Reese, George. King, Tim ', 'MySQL and mSQL', 'MySQL and mSQL', 'SQL (Computer program language); Relational databases; Database management; ', 'OReilly', '1999', 'QA76.73.S67 Y37 1999', 'xv, 487 p. : ill. ; 24 cm.', 'Randy Jay Yarger, George Reese, and Tim King. "Databases for moderate-sized organizations & web sites"--Cover. Includes index. ', 'Randy Jay Yarger, George Reese, and Tim King.');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Yust, Walter Chicago ', 'Encyclopedia Britannica', 'Encyclopedia Britannica', 'Encyclopedias and dictionaries. [from old catalog]; ', 'Encyclopedia Britannica', '[1948]', 'AE5 .E363 1948', '24 v. illus. (part col.), ports., maps (part col.) 29 cm.', '', '');
INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('Zicree, Marc Scott. ', 'The twilight zone companion', 'twilight zone companion', '', 'Silman-James Press', '1992', 'PN1992.77.T87 Z52 1992', 'p. cm.', 'by Marc Scott Zicree. Includes index. ', 'by Marc Scott Zicree.');
