<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
	
	<xsl:output 
		method="xml"
		omit-xml-declaration="no"
		indent="yes"
		doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" 
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />
		
	<!-- catalog -->
	<xsl:template match="catalog">
		<html>
			<head>
				<title><xsl:value-of select="caption"/></title>
			</head>
			<body>
				<table>
					<xsl:apply-templates select="caption"/>
					<xsl:apply-templates select="structure"/>
					<xsl:apply-templates select="work"/>
				</table>
			</body>
		</html>
	</xsl:template>
	
	<!-- caption -->
	<xsl:template match="caption">
		<caption style="text-align: center; margin-bottom: 1em"><xsl:value-of select="."/></caption>
	</xsl:template>
	 
	<!-- structure -->
	<xsl:template match="structure">
		<thead style="font-weight: bold">
			<tr><xsl:apply-templates/></tr>
		</thead>
	</xsl:template>
	 
	<!-- work -->
	<xsl:template match="work">
		<tr><xsl:apply-templates/></tr>
	</xsl:template>
	 
	<!-- title -->
	<xsl:template match="title">
		<td style="text-align: right; padding: 3px"><xsl:value-of select="."/></td>
	</xsl:template>
	 
	<!-- author, type, or date -->
	<xsl:template match="author | type | date">
		<td><xsl:value-of select="."/></td>
	</xsl:template>
	 	 
</xsl:stylesheet>