<xsl:template name="people">

<!--

	people.xsl - transform Google Onebox module data into HTML snipett
	
	Eric Lease Morgan (emorgan@nd.edu)
	
	June 13, 2008 - first documentation; call it version 1.0
	
-->

<table>
  <tr>
    <td colspan="2" style="font-weight: bold">People search</td>
  </tr>
  <tr>
    <td valign="top">
      <img src="http://dewey.library.nd.edu/box/people.png"/>
    </td>
    <td valign="top">
	 <xsl:for-each select="MODULE_RESULT">
		<!-- name and email -->
		<a>
		<xsl:attribute name='href'><xsl:text>mailto:</xsl:text><xsl:value-of select="./Field[@name='email']"/></xsl:attribute>
		<xsl:value-of select="./Field[@name='name']"/>
		</a>

		<!-- affiliation -->
		<xsl:if test="./Field[@name='affiliation'] != ''">
			<xsl:text> (</xsl:text>
			<xsl:value-of select="./Field[@name='affiliation']"/>
			<xsl:text>)</xsl:text>
		</xsl:if>

		<!-- title -->
		<xsl:if test="./Field[@name='title'] != ''">
			<xsl:text>, </xsl:text>
			<xsl:value-of select="./Field[@name='title']"/>
		</xsl:if>
		
		<!-- department -->
		<xsl:if test="./Field[@name='department'] != ''">
			<xsl:text>, </xsl:text>
			<xsl:value-of select="./Field[@name='department']"/>
		</xsl:if>

		<!-- telephone -->
		<xsl:if test="./Field[@name='telephone'] != ''">
			<xsl:text>, </xsl:text>
			<xsl:value-of select="./Field[@name='telephone']"/>
		</xsl:if>

		<!-- details -->
		<xsl:text> -- </xsl:text>
		<a>
		<xsl:attribute name='href'><xsl:value-of select="./Field[@name='detail']"/></xsl:attribute>
		<xsl:text>Details...</xsl:text>
		</a>

		<br/>
	 </xsl:for-each>
	 <xsl:if test="MODULE_RESULT/Field[@name='more']">
		<xsl:text>Displaying </xsl:text>
		<xsl:value-of select="MODULE_RESULT/Field[@name='upper']"/>
		<xsl:text> of </xsl:text>
		<xsl:value-of select="MODULE_RESULT/Field[@name='total']"/>
		<xsl:text> items. </xsl:text>
		<a>
		<xsl:attribute name='href'><xsl:value-of select="MODULE_RESULT/Field[@name='more']"/></xsl:attribute>
		<xsl:text>More...</xsl:text>
		</a>
	</xsl:if>
	</td>
  </tr>
</table>

 </xsl:template>
